/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator.integration;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.validator.GarbageKafkaAvroSerializer;
import io.confluent.kafka.schemaregistry.validator.integration.RecordSchemaValidatorIntegrationTestHarness;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.subject.RecordNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import io.confluent.kafka.serializers.subject.TopicRecordNameStrategy;
import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultiTopicRecordSchemaValidatorTests
extends RecordSchemaValidatorIntegrationTestHarness {
    public MultiTopicRecordSchemaValidatorTests() {
        super(3, true, CompatibilityLevel.NONE.name);
    }

    @Test
    public void testMultiTopicWithValueValidationEnabledDisabled() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        this.createTopic("topic1", false, true, null, null);
        this.createTopic("topic2", false, false, null, null);
        this.createTopic("topic3", false, true, null, null);
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(KafkaAvroSerializer.class, GarbageKafkaAvroSerializer.class);){
            ProducerRecord message;
            try {
                message = new ProducerRecord("topic1", (Object)this.mockAvroRecord, (Object)this.mockAvroRecord);
                kafkaProducer.send(message).get();
                Assertions.fail((String)"topic1: It should throw an exception here");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidRecordException));
            }
            try {
                message = new ProducerRecord("topic2", (Object)this.mockAvroRecord, (Object)this.mockAvroRecord);
                kafkaProducer.send(message).get();
            }
            catch (Exception e) {
                Assertions.fail((String)"topic2: It should not throw an exception here");
            }
            try {
                message = new ProducerRecord("topic3", (Object)this.mockAvroRecord, (Object)this.mockAvroRecord);
                kafkaProducer.send(message).get();
                Assertions.fail((String)"topic3: It should throw an exception here");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidRecordException));
            }
        }
    }

    @Test
    public void testMultiTopicWithDifferentValueValidationStrategySuccess() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        this.createTopic("topic1", false, true, null, RecordNameStrategy.class.getName());
        this.createTopic("topic2", false, true, null, TopicNameStrategy.class.getName());
        this.createTopic("topic3", false, true, null, TopicRecordNameStrategy.class.getName());
        this.createTopic("topic4", false, true, null, null);
        this.produceRecord("topic1", null, RecordNameStrategy.class, false);
        this.produceRecord("topic2", null, TopicNameStrategy.class, false);
        this.produceRecord("topic3", null, TopicRecordNameStrategy.class, false);
        this.produceRecord("topic4", null, TopicNameStrategy.class, false);
    }

    @Test
    public void testMultiTopicWithDifferentValueValidationStrategyFail() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        this.createTopic("topic1", false, true, null, RecordNameStrategy.class.getName());
        this.createTopic("topic2", false, true, null, TopicNameStrategy.class.getName());
        this.createTopic("topic3", false, true, null, TopicRecordNameStrategy.class.getName());
        this.createTopic("topic4", false, true, null, null);
        this.produceRecord("topic1", null, TopicNameStrategy.class, true);
        this.produceRecord("topic2", null, TopicRecordNameStrategy.class, true);
        this.produceRecord("topic3", null, RecordNameStrategy.class, true);
        this.produceRecord("topic4", null, RecordNameStrategy.class, true);
    }

    @Test
    public void testMultiTopicWithKeyValidationEnabledDisabled() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        this.createTopic("topic1", true, false, null, null);
        this.createTopic("topic2", false, false, null, null);
        this.createTopic("topic3", true, false, null, null);
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(GarbageKafkaAvroSerializer.class, KafkaAvroSerializer.class);){
            ProducerRecord message;
            try {
                message = new ProducerRecord("topic1", (Object)this.mockAvroRecord, (Object)this.mockAvroRecord);
                kafkaProducer.send(message).get();
                Assertions.fail((String)"topic1: It should throw an exception here");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidRecordException));
            }
            try {
                message = new ProducerRecord("topic2", (Object)this.mockAvroRecord, (Object)this.mockAvroRecord);
                kafkaProducer.send(message).get();
            }
            catch (Exception e) {
                Assertions.fail((String)"topic2: It should not throw an exception here");
            }
            try {
                message = new ProducerRecord("topic3", (Object)this.mockAvroRecord, (Object)this.mockAvroRecord);
                kafkaProducer.send(message).get();
                Assertions.fail((String)"topic3: It should throw an exception here");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidRecordException));
            }
        }
    }

    @Test
    public void testMultiTopicWithDifferentKeyValidationStrategySuccess() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        this.createTopic("topic1", true, false, RecordNameStrategy.class.getName(), null);
        this.createTopic("topic2", true, false, TopicNameStrategy.class.getName(), null);
        this.createTopic("topic3", true, false, TopicRecordNameStrategy.class.getName(), null);
        this.createTopic("topic4", true, false, null, null);
        this.produceRecord("topic1", RecordNameStrategy.class, null, false);
        this.produceRecord("topic2", TopicNameStrategy.class, null, false);
        this.produceRecord("topic3", TopicRecordNameStrategy.class, null, false);
        this.produceRecord("topic4", TopicNameStrategy.class, null, false);
    }

    @Test
    public void testMultiTopicWithDifferentKeyValidationStrategyFail() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        this.createTopic("topic1", true, false, RecordNameStrategy.class.getName(), null);
        this.createTopic("topic2", true, false, TopicNameStrategy.class.getName(), null);
        this.createTopic("topic3", true, false, TopicRecordNameStrategy.class.getName(), null);
        this.createTopic("topic4", true, false, null, null);
        this.produceRecord("topic1", TopicNameStrategy.class, null, true);
        this.produceRecord("topic2", TopicRecordNameStrategy.class, null, true);
        this.produceRecord("topic3", RecordNameStrategy.class, null, true);
        this.produceRecord("topic4", RecordNameStrategy.class, null, true);
    }

    @Test
    public void testMultiTopicWithDifferentKeyValueValidationStrategy() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        this.createTopic("topic1", true, true, RecordNameStrategy.class.getName(), TopicRecordNameStrategy.class.getName());
        this.createTopic("topic2", true, true, TopicRecordNameStrategy.class.getName(), RecordNameStrategy.class.getName());
        this.createTopic("topic3", true, true, TopicNameStrategy.class.getName(), RecordNameStrategy.class.getName());
        this.produceRecord("topic1", RecordNameStrategy.class, TopicRecordNameStrategy.class, false);
        this.produceRecord("topic2", TopicRecordNameStrategy.class, RecordNameStrategy.class, false);
        this.produceRecord("topic3", RecordNameStrategy.class, TopicNameStrategy.class, true);
    }

    private void createTopic(String topicName, boolean keyValidation, boolean valueValidation, String keyValidationStrategyConfig, String valueValidationStrategyConfig) {
        NewTopic testTopic = new NewTopic(topicName, 1, 1);
        HashMap<String, String> topicProps = new HashMap<String, String>();
        topicProps.put("confluent.key.schema.validation", keyValidation ? "true" : "false");
        topicProps.put("confluent.value.schema.validation", valueValidation ? "true" : "false");
        if (keyValidationStrategyConfig != null) {
            topicProps.put("confluent.key.subject.name.strategy", keyValidationStrategyConfig);
        }
        if (valueValidationStrategyConfig != null) {
            topicProps.put("confluent.value.subject.name.strategy", valueValidationStrategyConfig);
        }
        testTopic.configs(topicProps);
        this.createTopicThroughAdminClient(testTopic);
    }

    private KafkaProducer<Object, Object> createProducer(Class<?> keySerilizerClass, Class<?> valueSerilizerClass, Class<?> keyStrategyClass, Class<?> valueStrategyClass) {
        Properties props = this.getProducerProps();
        props.put("key.serializer", keySerilizerClass);
        props.put("value.serializer", valueSerilizerClass);
        if (keyStrategyClass != null) {
            props.put("key.subject.name.strategy", keyStrategyClass);
        }
        if (valueStrategyClass != null) {
            props.put("value.subject.name.strategy", valueStrategyClass);
        }
        return new KafkaProducer(props);
    }

    private void produceRecord(String topicName, Class<?> keyStrategyClass, Class<?> valueStrategyClass, boolean shouldFail) {
        block9: {
            try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(keyStrategyClass == null ? StringSerializer.class : KafkaAvroSerializer.class, valueStrategyClass == null ? StringSerializer.class : KafkaAvroSerializer.class, keyStrategyClass, valueStrategyClass);){
                ProducerRecord message = new ProducerRecord(topicName, (Object)(keyStrategyClass == null ? "key" : this.mockAvroRecord), (Object)(valueStrategyClass == null ? "value" : this.mockAvroRecord));
                kafkaProducer.send(message).get();
                if (shouldFail) {
                    Assertions.fail((String)"The call should throw an exception");
                }
            }
            catch (Exception e) {
                if (shouldFail) break block9;
                Assertions.fail((String)("Unexpected exception:" + e.toString()));
            }
        }
    }
}

