/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator;

import com.google.common.base.Ticker;
import com.google.common.testing.FakeTicker;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.validator.LruSchemaRegistryClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class LruSchemaRegistryClientTest {
    @Mock
    private RestService restService;
    private SchemaRegistryClient client;
    private SchemaString mockSchema = new SchemaString("{\"type\": \"string\"}");

    @Before
    public void setUp() throws Exception {
        this.mockSchema.setMaxId(Integer.valueOf(1));
        Mockito.when((Object)this.restService.getId(ArgumentMatchers.anyInt(), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.eq((boolean)true))).thenThrow(new Throwable[]{new RestClientException("ID not found", 404, 40403)}).thenReturn((Object)this.mockSchema);
    }

    @Test
    public void testSuccessOneRetry() throws Exception {
        this.client = new LruSchemaRegistryClient(this.restService, 1000, 1, 100, null, null, Ticker.systemTicker(), 5, 60L, 60L);
        Assert.assertNotNull((Object)this.client.getSchemaById(1));
        ((RestService)Mockito.verify((Object)this.restService, (VerificationMode)Mockito.times((int)2))).getId(1, null, true);
    }

    @Test
    public void testSuccessWithRef() throws Exception {
        SchemaString parentSchema = new SchemaString("{\"type\": \"string\"}");
        parentSchema.setMaxId(Integer.valueOf(1));
        parentSchema.setReferences(Collections.singletonList(new SchemaReference("ref1Name", "ref1", Integer.valueOf(1))));
        String ref1String = "{\"type\": \"int\"}";
        Schema ref1Schema = new Schema("ref1", Integer.valueOf(1), Integer.valueOf(100), "AVRO", Collections.emptyList(), ref1String);
        RestService workingRestService = (RestService)Mockito.mock(RestService.class);
        Mockito.when((Object)workingRestService.getId(1, null, true)).thenReturn((Object)parentSchema);
        Mockito.when((Object)workingRestService.getVersion("ref1", 1, true)).thenReturn((Object)ref1Schema);
        this.client = new LruSchemaRegistryClient(workingRestService, 1000, 1, 100, null, null, Ticker.systemTicker(), 5, 60L, 60L);
        Assert.assertNotNull((Object)this.client.getSchemaById(1));
        ((RestService)Mockito.verify((Object)workingRestService, (VerificationMode)Mockito.times((int)1))).getId(1, null, true);
    }

    @Test(expected=RestClientException.class)
    public void testFailureNoRetries() throws Exception {
        this.client = new LruSchemaRegistryClient(this.restService, 1000, 0, 100, null, null, Ticker.systemTicker(), 5, 60L, 60L);
        this.client.getSchemaById(1);
    }

    @Test
    public void testMissingIdCacheRejectsRecordWithBannedId() throws Exception {
        this.client = new LruSchemaRegistryClient(this.restService, 1000, 0, 100, null, null, Ticker.systemTicker(), 5, 60L, 60L);
        try {
            this.client.getSchemaById(1);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"ID not found; error code: 40403");
        }
        Thread.sleep(100L);
        try {
            this.client.getSchemaById(1);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"This ID 1 is banned; error code: 40403");
        }
    }

    @Test
    public void testRejectIdAboveRangeQuery() throws Exception {
        RestService workingRestService = (RestService)Mockito.mock(RestService.class);
        Mockito.when((Object)workingRestService.getId(ArgumentMatchers.anyInt(), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)this.mockSchema);
        this.client = new LruSchemaRegistryClient(workingRestService, 1000, 0, 100, null, null, Ticker.systemTicker(), 5, 60L, 60L);
        Assert.assertNotNull((Object)this.client.getSchemaById(1));
        Assert.assertNotNull((Object)this.client.getSchemaById(4));
        try {
            this.client.getSchemaById(7);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"This ID 7 is not allowed; error code: 40403");
        }
    }

    @Test
    public void testAcceptIdAfterTtl() throws Exception {
        FakeTicker fakeTicker = new FakeTicker();
        this.client = new LruSchemaRegistryClient(this.restService, 1000, 0, 100, null, null, (Ticker)fakeTicker, 5, 60L, 60L);
        try {
            this.client.getSchemaById(1);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"ID not found; error code: 40403");
        }
        fakeTicker.advance(60L, TimeUnit.SECONDS);
        Thread.sleep(100L);
        Assert.assertNotNull((Object)this.client.getSchemaById(1));
    }

    @Test
    public void testRejectBasedOnRangeQueryThenRejectBasedOnMissingIdCache() throws Exception {
        RestService workingRestService = (RestService)Mockito.mock(RestService.class);
        Mockito.when((Object)workingRestService.getId(ArgumentMatchers.anyInt(), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)this.mockSchema);
        this.client = new LruSchemaRegistryClient(workingRestService, 1000, 0, 100, null, null, Ticker.systemTicker(), 5, 60L, 60L);
        this.client.getSchemaById(1);
        try {
            this.client.getSchemaById(7);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"This ID 7 is not allowed; error code: 40403");
        }
        Thread.sleep(100L);
        try {
            this.client.getSchemaById(7);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"This ID 7 is banned; error code: 40403");
        }
    }

    @Test
    public void testAcceptWhenFirstIdAboveQueryRange() throws Exception {
        RestService workingRestService = (RestService)Mockito.mock(RestService.class);
        this.mockSchema.setMaxId(Integer.valueOf(1001));
        Mockito.when((Object)workingRestService.getId(ArgumentMatchers.anyInt(), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)this.mockSchema);
        this.client = new LruSchemaRegistryClient(workingRestService, 1000, 0, 100, null, null, Ticker.systemTicker(), 5, 60L, 60L);
        Assert.assertNotNull((Object)this.client.getSchemaById(1001));
        try {
            this.client.getSchemaById(1007);
            Assert.fail();
        }
        catch (RestClientException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"This ID 1007 is not allowed; error code: 40403");
        }
    }

    @Test(timeout=3000L)
    public void testIdCacheAsyncLoading() throws Exception {
        HashSet<Integer> remainingIds = new HashSet<Integer>();
        boolean minId = true;
        int maxId = 100;
        int delayId = 100;
        RestService workingRestService = (RestService)Mockito.mock(RestService.class);
        Mockito.when((Object)workingRestService.getId(ArgumentMatchers.anyInt(), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.eq((boolean)true))).then(invocationOnMock -> {
            Integer id = (Integer)invocationOnMock.getArgument(0, Integer.class);
            LruSchemaRegistryClientTest.delayResponse(remainingIds, 100, id);
            return this.mockSchema;
        });
        this.verifyAsyncLoading(workingRestService, remainingIds, 1, 100, (srClient, integer) -> () -> srClient.getSchemaById(integer.intValue()));
    }

    @Test(timeout=3000L)
    public void testSchemaCacheAsyncLoading() throws Exception {
        String subject = "subjectA";
        String schemaType = "schemaType";
        HashSet<Integer> remainingIds = new HashSet<Integer>();
        boolean minId = true;
        int maxId = 100;
        int delayId = 100;
        RestService workingRestService = (RestService)Mockito.mock(RestService.class);
        Mockito.when((Object)workingRestService.lookUpSubjectVersion((RegisterSchemaRequest)ArgumentMatchers.any(RegisterSchemaRequest.class), (String)ArgumentMatchers.eq((Object)"subjectA"), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false))).then(invocationOnMock -> {
            RegisterSchemaRequest request = (RegisterSchemaRequest)invocationOnMock.getArgument(0, RegisterSchemaRequest.class);
            Integer id = Integer.parseInt(request.getSchema());
            LruSchemaRegistryClientTest.delayResponse(remainingIds, 100, id);
            return new Schema("subjectA", request);
        });
        this.verifyAsyncLoading(workingRestService, remainingIds, 1, 100, (srClient, integer) -> () -> srClient.getId("subjectA", LruSchemaRegistryClientTest.getParsedSchemaMock(integer, "schemaType")));
    }

    private void verifyAsyncLoading(RestService workingRestService, Set<Integer> remainingIds, int minId, int maxId, BiFunction<SchemaRegistryClient, Integer, Callable<Object>> func) throws Exception {
        int i;
        this.client = new LruSchemaRegistryClient(workingRestService, 1000, 0, 100, null, null, Ticker.systemTicker(), 1000, 60L, 60L);
        ExecutorService executor = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors()));
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (i = minId; i <= maxId; ++i) {
            remainingIds.add(i);
        }
        for (i = maxId; i >= minId; --i) {
            Callable<Object> callable = func.apply(this.client, i);
            futures.add(executor.submit(callable));
        }
        for (Future future : futures) {
            Assert.assertNotNull(future.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void delayResponse(Set<Integer> remainingIds, int delayId, Integer id) throws InterruptedException {
        Set<Integer> set = remainingIds;
        synchronized (set) {
            if (id == delayId) {
                while (remainingIds.size() != 1) {
                    remainingIds.wait();
                }
                Assert.assertEquals((Object)id, (Object)remainingIds.iterator().next());
            }
            Assert.assertTrue((String)("ID already removed: " + id), (boolean)remainingIds.remove(id));
            remainingIds.notifyAll();
        }
    }

    private static ParsedSchema getParsedSchemaMock(int i, String type) {
        ParsedSchema schema = (ParsedSchema)Mockito.mock(ParsedSchema.class);
        Mockito.when((Object)schema.canonicalString()).thenReturn((Object)Integer.toString(i));
        Mockito.when((Object)schema.toString()).thenReturn((Object)Integer.toString(i));
        Mockito.when((Object)schema.schemaType()).thenReturn((Object)type);
        Mockito.when((Object)schema.references()).thenReturn(null);
        return schema;
    }
}

