/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator.integration.strategies;

import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityLevel;
import io.confluent.kafka.schemaregistry.validator.integration.RecordSchemaValidatorIntegrationTestHarness;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.StringSerializer;

public class StrategyBrokerTest
extends RecordSchemaValidatorIntegrationTestHarness {
    public StrategyBrokerTest() {
        super(1, true, AvroCompatibilityLevel.NONE.name);
    }

    protected KafkaProducer<Object, Object> createProducer(Class<?> strategyClass) {
        Properties props = this.getProducerProps();
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", KafkaAvroSerializer.class);
        props.put("value.subject.name.strategy", strategyClass);
        return new KafkaProducer(props);
    }

    protected void createTopic(Class<?> subjectNameClass) {
        NewTopic testTopic = new NewTopic("test", 1, 1);
        HashMap<String, String> topicProps = new HashMap<String, String>();
        topicProps.put("confluent.value.schema.validation", "true");
        topicProps.put("confluent.value.subject.name.strategy", subjectNameClass.getName());
        testTopic.configs(topicProps);
        this.createTopicThroughAdminClient(testTopic);
    }
}

