/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator.integration.strategies;

import io.confluent.kafka.schemaregistry.validator.integration.strategies.StrategyBrokerTest;
import io.confluent.kafka.serializers.subject.RecordNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import io.confluent.kafka.serializers.subject.TopicRecordNameStrategy;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.InvalidRecordException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RecordNameStrategyBrokerTest
extends StrategyBrokerTest {
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createTopic(RecordNameStrategy.class);
    }

    @Test
    public void testProducerHasTopicNameStrategyIsRejected() {
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(TopicNameStrategy.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)"key", (Object)this.mockAvroRecord);
            kafkaProducer.send(message).get();
            Assert.fail((String)"It should throw an exception here");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidRecordException));
        }
    }

    @Test
    public void testProducerHasRecordNameStrategyIsAccepted() throws Exception {
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(RecordNameStrategy.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)"key", (Object)this.mockAvroRecord);
            kafkaProducer.send(message).get();
        }
    }

    @Test
    public void testProducerHasTopicRecordNameStrategyIsRejected() {
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(TopicRecordNameStrategy.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)"key", (Object)this.mockAvroRecord);
            kafkaProducer.send(message).get();
            Assert.fail((String)"It should throw an exception here");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidRecordException));
        }
    }
}

