/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator.integration;

import io.confluent.kafka.schemaregistry.validator.integration.ValidationAuthTest;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Test;

public class ValidationAuthSuccessTest
extends ValidationAuthTest {
    @Override
    public void injectProperties(Properties props) {
        super.injectProperties(props);
        props.put("confluent.basic.auth.credentials.source", "USER_INFO");
        props.put("confluent.basic.auth.user.info", "admin:password");
    }

    @Test
    public void testCorrectlyFormattedDataIsAccepted() throws Exception {
        this.setupBasicAuthClient("admin", "password");
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(StringSerializer.class, KafkaAvroSerializer.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)this.mockAvroRecord);
            kafkaProducer.send(message).get();
        }
        catch (Exception e) {
            TestCase.fail((String)"The future is supposed to succeed");
        }
    }
}

