/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator.integration;

import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityLevel;
import io.confluent.kafka.schemaregistry.rest.SecureTestUtils;
import io.confluent.kafka.schemaregistry.validator.integration.RecordSchemaValidatorIntegrationTestHarness;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.security.auth.login.Configuration;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.config.types.Password;
import org.junit.Before;

public class SchemaValidationSslTest
extends RecordSchemaValidatorIntegrationTestHarness {
    private Properties schemaRegistryProps = new Properties();
    protected Map<String, Object> clientSslConfigs = new HashMap<String, Object>();

    public SchemaValidationSslTest() {
        super(1, true, AvroCompatibilityLevel.NONE.name);
        Configuration.setConfiguration(null);
        this.schemaRegistryProps.put("inter.instance.protocol", "https");
        this.schemaRegistryProps.put("ssl.endpoint.identification.algorithm", "");
        try {
            File trustStoreFile = File.createTempFile("truststore", ".jks");
            trustStoreFile.deleteOnExit();
            ArrayList clientCerts = new ArrayList();
            ArrayList keyPairs = new ArrayList();
            this.schemaRegistryProps.putAll((Map<?, ?>)SecureTestUtils.clientSslConfigsWithKeyStore((int)1, (File)trustStoreFile, (Password)new Password("TrustPassword"), clientCerts, keyPairs));
            this.schemaRegistryProps.put("ssl.client.authentication", "REQUIRED");
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creating SSL credentials", e);
        }
        this.clientSslConfigs.put("confluent.ssl.protocol", "TLS");
        this.clientSslConfigs.put("confluent.ssl.keystore.location", this.schemaRegistryProps.get("ssl.keystore.location"));
        this.clientSslConfigs.put("confluent.ssl.keystore.password", this.schemaRegistryProps.get("ssl.keystore.password"));
        this.clientSslConfigs.put("confluent.ssl.key.password", this.schemaRegistryProps.get("ssl.key.password"));
        this.clientSslConfigs.put("confluent.ssl.keystore.type", this.schemaRegistryProps.get("ssl.keystore.type"));
        this.clientSslConfigs.put("confluent.ssl.truststore.location", this.schemaRegistryProps.get("ssl.truststore.location"));
        this.clientSslConfigs.put("confluent.ssl.truststore.password", this.schemaRegistryProps.get("ssl.truststore.password"));
        this.clientSslConfigs.put("confluent.ssl.truststore.type", this.schemaRegistryProps.get("ssl.truststore.type"));
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        NewTopic testTopic = new NewTopic("test", 1, 1);
        testTopic.configs(Collections.singletonMap("confluent.value.schema.validation", "true"));
        this.createTopicThroughAdminClient(testTopic);
    }

    @Override
    protected Properties getProducerProps() {
        Properties props = super.getProducerProps();
        props.putAll(this.clientSslConfigs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("confluent.")).collect(Collectors.toMap(e -> "schema.registry." + ((String)e.getKey()).substring("confluent.".length()), Map.Entry::getValue)));
        return props;
    }

    protected String getSchemaRegistryProtocol() {
        return "https";
    }

    protected Properties getSchemaRegistryProperties() {
        return this.schemaRegistryProps;
    }

    protected void setupHostNameVerifier() {
        HostnameVerifier allHostsValid = (hostname, session) -> true;
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }
}

