/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator.integration;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.RestApp;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator;
import io.confluent.kafka.serializers.subject.RecordNameStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.metrics.KafkaYammerMetrics;
import kafka.utils.TestUtils;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.junit.Assert;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class RecordSchemaValidatorIntegrationTestHarness
extends ClusterTestHarness {
    protected static final String TEST_TOPIC = "test";
    protected static final String TEST_SUBJECT = "testSubject";
    protected static final String TEST_SCHEMA_STRING = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}";
    protected Admin adminClient;
    protected IndexedRecord mockAvroRecord = this.createAvroRecord("{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", Collections.singletonMap("name", "testUser"));

    public RecordSchemaValidatorIntegrationTestHarness(int numBrokers, boolean setupRestApp, String compatibilityType) {
        super(numBrokers, setupRestApp, compatibilityType);
    }

    public void injectProperties(Properties props) {
        this.schemaRegistryPort = RecordSchemaValidatorIntegrationTestHarness.choosePort();
        props.setProperty("confluent.schema.registry.url", this.getSchemaRegistryProtocol() + "://0.0.0.0:" + this.schemaRegistryPort);
        props.setProperty("num.partitions", "1");
    }

    private void registerTestSubject(RestApp clientRestApp, String schema, String subject) throws Exception {
        String userSchema = AvroUtils.parseSchema((String)schema).canonicalString();
        clientRestApp.restClient.registerSchema(userSchema, subject);
    }

    protected Properties getProducerProps() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList);
        props.put("acks", "-1");
        props.put("schema.registry.url", this.restApp.restConnect);
        props.put("confluent.value.subject.name.strategy", RecordNameStrategy.class);
        return props;
    }

    protected KafkaProducer<Object, Object> createProducer(Class<?> keySerializer, Class<?> valueSerializer) {
        Properties props = this.getProducerProps();
        props.put("key.serializer", keySerializer);
        props.put("value.serializer", valueSerializer);
        return new KafkaProducer(props);
    }

    protected KafkaProducer<Object, Object> createProducer(Class<?> keySerializer, Class<?> valueSerializer, String schemaUrl) {
        Properties props = this.getProducerProps();
        props.put("key.serializer", keySerializer);
        props.put("value.serializer", valueSerializer);
        props.put("schema.registry.url", schemaUrl);
        return new KafkaProducer(props);
    }

    protected IndexedRecord createAvroRecord(String schemaString, Map<String, Object> data) {
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(schemaString);
        GenericData.Record avroRecord = new GenericData.Record(schema);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            avroRecord.put(entry.getKey(), entry.getValue());
        }
        return avroRecord;
    }

    protected byte[] messageContentWithInvalidSchemaId() {
        byte[] content = new byte[10];
        content[4] = 2;
        return content;
    }

    public void checkRegisterSubjectThroughRestClient(RestApp clientRestApp, String schema, String subject) throws Exception {
        this.registerTestSubject(clientRestApp, schema, subject);
        Assert.assertEquals((long)1L, (long)clientRestApp.restClient.getAllVersions(subject).size());
    }

    protected AdminClient createAdminClient() {
        Properties adminClientConfigs = new Properties();
        adminClientConfigs.put("bootstrap.servers", this.brokerList);
        return AdminClient.create((Properties)adminClientConfigs);
    }

    protected void createTopicThroughAdminClient(NewTopic topic) {
        this.adminClient = this.createAdminClient();
        try {
            this.adminClient.createTopics(Collections.singletonList(topic)).all().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        TestUtils.waitUntilMetadataIsPropagated((Seq)JavaConverters.asScalaBuffer((List)this.servers), (String)topic.name(), (int)0, (long)30000L);
    }

    public void checkMetricsAreRecorded() {
        Assert.assertEquals((long)1L, (long)KafkaYammerMetrics.defaultRegistry().allMetrics().keySet().stream().filter(m -> m.getMBeanName().startsWith("kafka.log:type=InterceptorMetrics,name=TotalRejectedRecordsPerSec,topic=test,interceptorClassName=" + RecordSchemaValidator.class.getName())).count());
    }
}

