/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator.integration;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.validator.GarbageKafkaAvroSerializer;
import io.confluent.kafka.schemaregistry.validator.integration.RecordSchemaValidatorIntegrationTestHarness;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.util.Collections;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeyValidationTest
extends RecordSchemaValidatorIntegrationTestHarness {
    public KeyValidationTest() {
        super(1, true, CompatibilityLevel.NONE.name);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        NewTopic testTopic = new NewTopic("test", 1, 1);
        testTopic.configs(Collections.singletonMap("confluent.key.schema.validation", "true"));
        this.createTopicThroughAdminClient(testTopic);
    }

    @Test
    public void testCorrectlyFormattedDataIsAccepted() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(KafkaAvroSerializer.class, StringSerializer.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)this.mockAvroRecord, (Object)"value");
            kafkaProducer.send(message).get();
        }
        catch (Exception e) {
            Assert.fail((String)"The future is supposed to succeed");
        }
    }

    @Test
    public void testGarbageKeyDataIsRejected() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(GarbageKafkaAvroSerializer.class, StringSerializer.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)this.mockAvroRecord, (Object)"value");
            kafkaProducer.send(message).get();
            Assert.fail((String)"It should throw an exception here");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidRecordException));
        }
        this.checkMetricsAreRecorded();
    }

    @Test
    public void testGarbageValueDataIsAccepted() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(KafkaAvroSerializer.class, GarbageKafkaAvroSerializer.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)this.mockAvroRecord, (Object)this.mockAvroRecord);
            kafkaProducer.send(message).get();
        }
        catch (Exception e) {
            Assert.fail((String)"The future is supposed to succeed");
        }
    }

    @Test
    public void testNonExistentSchemaDataIsRejected() throws Exception {
        this.checkRegisterSubjectThroughRestClient(this.restApp, "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}", "testSubject");
        try (KafkaProducer<Object, Object> kafkaProducer = this.createProducer(ByteArraySerializer.class, StringSerializer.class);){
            ProducerRecord message = new ProducerRecord("test", (Object)this.messageContentWithInvalidSchemaId(), (Object)"value");
            kafkaProducer.send(message).get();
            Assert.fail((String)"It should throw an exception here");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidRecordException));
        }
        this.checkMetricsAreRecorded();
    }
}

