/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.validator;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.validator.LruSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.subject.RecordNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import io.confluent.kafka.serializers.subject.TopicRecordNameStrategy;
import io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.DefaultRecord;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.server.interceptor.RecordInterceptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RecordSchemaValidatorTest {
    private static final String TEST_TOPIC = "test";
    private Map<LruSchemaRegistryClient.SubjectAndSchema, Integer> schemas;
    private Cache<LruSchemaRegistryClient.SubjectAndSchema, Long> missingSchemas;
    private Map<Integer, ParsedSchema> ids;
    private Cache<Integer, Long> missingIds;
    private SchemaRegistryClient schemaRegistry;
    private Map<String, Object> defaultConfigs;
    private KafkaAvroSerializer keySerializer;
    private KafkaAvroSerializer valueSerializer;
    private Map<String, Object> recordNameStrategyConfigs;
    private KafkaAvroSerializer keySerializerWithRecordNameStrategy;
    private KafkaAvroSerializer valueSerializerWithRecordNameStrategy;
    private Map<String, Object> topicRecordNameStrategyConfigs;
    private KafkaAvroSerializer keySerializerWithTopicRecordNameStrategy;
    private KafkaAvroSerializer valueSerializerWithTopicRecordNameStrategy;

    @Before
    public void setUp() {
        this.schemas = new HashMap<LruSchemaRegistryClient.SubjectAndSchema, Integer>();
        this.missingSchemas = Caffeine.newBuilder().build();
        this.ids = new HashMap<Integer, ParsedSchema>();
        this.missingIds = Caffeine.newBuilder().build();
        this.schemaRegistry = new LruSchemaRegistryClient(RecordSchemaValidatorTest.schemaCache(this.schemas), RecordSchemaValidatorTest.idCache(this.ids), this.missingIds, 5, this.missingSchemas);
        this.defaultConfigs = new HashMap<String, Object>();
        this.defaultConfigs.put("schema.registry.url", "bogus");
        this.defaultConfigs.put("auto.register.schemas", "false");
        this.keySerializer = new KafkaAvroSerializer(this.schemaRegistry);
        this.keySerializer.configure(this.defaultConfigs, true);
        this.valueSerializer = new KafkaAvroSerializer(this.schemaRegistry);
        this.valueSerializer.configure(this.defaultConfigs, false);
        this.recordNameStrategyConfigs = new HashMap<String, Object>();
        this.recordNameStrategyConfigs.put("schema.registry.url", "bogus");
        this.recordNameStrategyConfigs.put("auto.register.schemas", "false");
        this.recordNameStrategyConfigs.put("key.subject.name.strategy", RecordNameStrategy.class.getName());
        this.recordNameStrategyConfigs.put("value.subject.name.strategy", RecordNameStrategy.class.getName());
        this.keySerializerWithRecordNameStrategy = new KafkaAvroSerializer(this.schemaRegistry);
        this.keySerializerWithRecordNameStrategy.configure(this.recordNameStrategyConfigs, true);
        this.valueSerializerWithRecordNameStrategy = new KafkaAvroSerializer(this.schemaRegistry);
        this.valueSerializerWithRecordNameStrategy.configure(this.recordNameStrategyConfigs, false);
        this.topicRecordNameStrategyConfigs = new HashMap<String, Object>();
        this.topicRecordNameStrategyConfigs.put("schema.registry.url", "bogus");
        this.topicRecordNameStrategyConfigs.put("auto.register.schemas", "false");
        this.topicRecordNameStrategyConfigs.put("key.subject.name.strategy", TopicRecordNameStrategy.class.getName());
        this.topicRecordNameStrategyConfigs.put("value.subject.name.strategy", TopicRecordNameStrategy.class.getName());
        this.keySerializerWithTopicRecordNameStrategy = new KafkaAvroSerializer(this.schemaRegistry);
        this.keySerializerWithTopicRecordNameStrategy.configure(this.topicRecordNameStrategyConfigs, true);
        this.valueSerializerWithTopicRecordNameStrategy = new KafkaAvroSerializer(this.schemaRegistry);
        this.valueSerializerWithTopicRecordNameStrategy.configure(this.topicRecordNameStrategyConfigs, false);
    }

    private RecordSchemaValidator createValidator(SchemaRegistryClient schemaRegistry, SubjectNameStrategy strategy) {
        RecordSchemaValidator validator = new RecordSchemaValidator(schemaRegistry);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("confluent.key.subject.name.strategy", strategy.getClass().getName());
        configs.put("confluent.value.subject.name.strategy", strategy.getClass().getName());
        configs.put("confluent.key.schema.validation", "true");
        configs.put("confluent.value.schema.validation", "true");
        configs.put("confluent.missing.id.query.range", "5");
        configs.put("confluent.missing.id.cache.ttl.sec", "3");
        validator.configure(configs);
        return validator;
    }

    private IndexedRecord createAvroRecord() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        return avroRecord;
    }

    @Test
    public void testValidateRecordValue() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String subject = strategy.subjectName(TEST_TOPIC, false, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] bytes = this.valueSerializer.serialize(TEST_TOPIC, (Object)avroRecord);
        BrokerRecord record = new BrokerRecord(null, bytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.ACCEPT, (Object)response);
    }

    @Test
    public void testValidateRecordKey() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String subject = strategy.subjectName(TEST_TOPIC, true, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] bytes = this.keySerializer.serialize(TEST_TOPIC, (Object)avroRecord);
        BrokerRecord record = new BrokerRecord(bytes, null);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.ACCEPT, (Object)response);
    }

    @Test
    public void testValidateRecordValueAndKey() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String keySubject = strategy.subjectName(TEST_TOPIC, true, (ParsedSchema)avroSchema);
        String valueSubject = strategy.subjectName(TEST_TOPIC, false, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(keySubject, (ParsedSchema)avroSchema), 1);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(valueSubject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] keyBytes = this.keySerializer.serialize(TEST_TOPIC, (Object)avroRecord);
        byte[] valueBytes = this.valueSerializer.serialize(TEST_TOPIC, (Object)avroRecord);
        BrokerRecord record = new BrokerRecord(keyBytes, valueBytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.ACCEPT, (Object)response);
    }

    @Test
    public void testValidateRecordValueWithRecordNameStrategy() throws Exception {
        RecordNameStrategy strategy = new RecordNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String subject = strategy.subjectName(TEST_TOPIC, false, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] bytes = this.valueSerializerWithRecordNameStrategy.serialize(TEST_TOPIC, (Object)avroRecord);
        BrokerRecord record = new BrokerRecord(null, bytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.ACCEPT, (Object)response);
    }

    @Test
    public void testValidateRecordKeyWithRecordNameStrategy() throws Exception {
        RecordNameStrategy strategy = new RecordNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String subject = strategy.subjectName(TEST_TOPIC, true, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] bytes = this.keySerializerWithRecordNameStrategy.serialize(TEST_TOPIC, (Object)avroRecord);
        BrokerRecord record = new BrokerRecord(bytes, null);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.ACCEPT, (Object)response);
    }

    @Test
    public void testValidateRecordValueAndKeyWithRecordNameStrategy() throws Exception {
        RecordNameStrategy strategy = new RecordNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String keySubject = strategy.subjectName(TEST_TOPIC, true, (ParsedSchema)avroSchema);
        String valueSubject = strategy.subjectName(TEST_TOPIC, false, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(keySubject, (ParsedSchema)avroSchema), 1);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(valueSubject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] keyBytes = this.keySerializerWithRecordNameStrategy.serialize(TEST_TOPIC, (Object)avroRecord);
        byte[] valueBytes = this.valueSerializerWithRecordNameStrategy.serialize(TEST_TOPIC, (Object)avroRecord);
        BrokerRecord record = new BrokerRecord(keyBytes, valueBytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.ACCEPT, (Object)response);
    }

    @Test
    public void testValidateRecordValueWithTopicRecordNameStrategy() throws Exception {
        TopicRecordNameStrategy strategy = new TopicRecordNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String subject = strategy.subjectName(TEST_TOPIC, false, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] bytes = this.valueSerializerWithTopicRecordNameStrategy.serialize(TEST_TOPIC, (Object)avroRecord);
        BrokerRecord record = new BrokerRecord(null, bytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.ACCEPT, (Object)response);
    }

    @Test
    public void testValidateRecordValueAndKeyWithTopicRecordNameStrategy() throws Exception {
        TopicRecordNameStrategy strategy = new TopicRecordNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String keySubject = strategy.subjectName(TEST_TOPIC, true, (ParsedSchema)avroSchema);
        String valueSubject = strategy.subjectName(TEST_TOPIC, false, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(keySubject, (ParsedSchema)avroSchema), 1);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(valueSubject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] keyBytes = this.keySerializerWithTopicRecordNameStrategy.serialize(TEST_TOPIC, (Object)avroRecord);
        byte[] valueBytes = this.valueSerializerWithTopicRecordNameStrategy.serialize(TEST_TOPIC, (Object)avroRecord);
        BrokerRecord record = new BrokerRecord(keyBytes, valueBytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.ACCEPT, (Object)response);
    }

    @Test
    public void testValidateRecordKeyWithTopicRecordNameStrategy() throws Exception {
        TopicRecordNameStrategy strategy = new TopicRecordNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String subject = strategy.subjectName(TEST_TOPIC, true, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] bytes = this.keySerializerWithTopicRecordNameStrategy.serialize(TEST_TOPIC, (Object)avroRecord);
        BrokerRecord record = new BrokerRecord(bytes, null);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.ACCEPT, (Object)response);
    }

    @Test
    public void testInvalidRecordKey() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String subject = strategy.subjectName(TEST_TOPIC, true, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] bytes = this.keySerializer.serialize(TEST_TOPIC, (Object)avroRecord);
        this.schemas.clear();
        this.ids.clear();
        BrokerRecord record = new BrokerRecord(bytes, null);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.REJECT, (Object)response);
    }

    @Test
    public void testInvalidRecordValue() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String subject = strategy.subjectName(TEST_TOPIC, false, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] bytes = this.valueSerializer.serialize(TEST_TOPIC, (Object)avroRecord);
        this.schemas.clear();
        this.ids.clear();
        BrokerRecord record = new BrokerRecord(null, bytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.REJECT, (Object)response);
    }

    @Test
    public void testGarbageRecordKey() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        byte[] bytes = new byte[]{10, 15};
        BrokerRecord record = new BrokerRecord(bytes, null);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.REJECT, (Object)response);
    }

    @Test
    public void testGarbageRecordValue() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        byte[] bytes = new byte[]{10, 15};
        BrokerRecord record = new BrokerRecord(null, bytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.REJECT, (Object)response);
    }

    @Test
    public void testGarbageRecordKeyWithMagicByte() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        byte[] bytes = new byte[]{0, 10, 15};
        BrokerRecord record = new BrokerRecord(bytes, null);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.REJECT, (Object)response);
    }

    @Test
    public void testGarbageRecordValueWithMagicByte() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        byte[] bytes = new byte[]{0, 10, 15};
        BrokerRecord record = new BrokerRecord(null, bytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator(this.schemaRegistry, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.REJECT, (Object)response);
    }

    @Test
    public void testMissingIdCachePutsIdAfterRejecting() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String subject = strategy.subjectName(TEST_TOPIC, false, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] bytes = this.valueSerializer.serialize(TEST_TOPIC, (Object)avroRecord);
        LruSchemaRegistryClient sr = new LruSchemaRegistryClient(RecordSchemaValidatorTest.schemaCache(new NotFoundSchemaMap<LruSchemaRegistryClient.SubjectAndSchema, Integer>()), RecordSchemaValidatorTest.idCache(new NotFoundSchemaMap<Integer, ParsedSchema>()), this.missingIds, 5, this.missingSchemas);
        BrokerRecord record = new BrokerRecord(null, bytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator((SchemaRegistryClient)sr, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.REJECT, (Object)response);
        Assert.assertEquals((long)this.missingIds.estimatedSize(), (long)1L);
        Assert.assertNotNull((Object)this.missingIds.getIfPresent((Object)1));
    }

    @Test
    public void testMissingSchemaCachePutsSubjectAndSchemaAfterRejecting() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String subject = strategy.subjectName(TEST_TOPIC, false, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] bytes = this.valueSerializer.serialize(TEST_TOPIC, (Object)avroRecord);
        LruSchemaRegistryClient sr = new LruSchemaRegistryClient(RecordSchemaValidatorTest.schemaCache(new NotFoundSchemaMap<LruSchemaRegistryClient.SubjectAndSchema, Integer>()), RecordSchemaValidatorTest.idCache(this.ids), this.missingIds, 5, this.missingSchemas);
        BrokerRecord record = new BrokerRecord(null, bytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator((SchemaRegistryClient)sr, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.REJECT, (Object)response);
        Assert.assertEquals((long)this.missingSchemas.estimatedSize(), (long)1L);
        Assert.assertNotNull((Object)this.missingSchemas.getIfPresent((Object)new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema)));
    }

    @Test
    public void testBadHttpResponse() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String subject = strategy.subjectName(TEST_TOPIC, false, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] bytes = this.valueSerializer.serialize(TEST_TOPIC, (Object)avroRecord);
        LruSchemaRegistryClient sr = new LruSchemaRegistryClient(RecordSchemaValidatorTest.schemaCache(new BadHttpResponseMap<LruSchemaRegistryClient.SubjectAndSchema, Integer>()), RecordSchemaValidatorTest.idCache(new BadHttpResponseMap<Integer, ParsedSchema>()), this.missingIds, 5, this.missingSchemas);
        BrokerRecord record = new BrokerRecord(null, bytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator((SchemaRegistryClient)sr, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.REJECT, (Object)response);
    }

    @Test
    public void testFailedConnection() throws Exception {
        TopicNameStrategy strategy = new TopicNameStrategy();
        IndexedRecord avroRecord = this.createAvroRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        String subject = strategy.subjectName(TEST_TOPIC, false, (ParsedSchema)avroSchema);
        this.schemas.put(new LruSchemaRegistryClient.SubjectAndSchema(subject, (ParsedSchema)avroSchema), 1);
        this.ids.put(1, (ParsedSchema)avroSchema);
        byte[] bytes = this.valueSerializer.serialize(TEST_TOPIC, (Object)avroRecord);
        LruSchemaRegistryClient sr = new LruSchemaRegistryClient(RecordSchemaValidatorTest.schemaCache(new FailedConnectionMap<LruSchemaRegistryClient.SubjectAndSchema, Integer>()), RecordSchemaValidatorTest.idCache(new FailedConnectionMap<Integer, ParsedSchema>()), this.missingIds, 5, this.missingSchemas);
        BrokerRecord record = new BrokerRecord(null, bytes);
        RecordInterceptor.RecordInterceptorResponse response = this.createValidator((SchemaRegistryClient)sr, (SubjectNameStrategy)strategy).onAppend(new TopicPartition(TEST_TOPIC, 0), (Record)record);
        Assert.assertEquals((Object)RecordInterceptor.RecordInterceptorResponse.REJECT, (Object)response);
    }

    static AsyncLoadingCache<LruSchemaRegistryClient.SubjectAndSchema, Integer> schemaCache(Map<LruSchemaRegistryClient.SubjectAndSchema, Integer> map) {
        return Caffeine.newBuilder().buildAsync(key -> {
            try {
                return (Integer)map.get(key);
            }
            catch (RuntimeException e) {
                throw (Exception)e.getCause();
            }
        });
    }

    static AsyncLoadingCache<Integer, ParsedSchema> idCache(Map<Integer, ParsedSchema> map) {
        return Caffeine.newBuilder().buildAsync(key -> {
            try {
                return (ParsedSchema)map.get(key);
            }
            catch (RuntimeException e) {
                throw (Exception)e.getCause();
            }
        });
    }

    static class NotFoundSchemaMap<K, V>
    extends HashMap<K, V> {
        NotFoundSchemaMap() {
        }

        @Override
        public V get(Object key) {
            throw new RuntimeException((Throwable)new RestClientException("not found", 404, 40403));
        }
    }

    static class FailedConnectionMap<K, V>
    extends HashMap<K, V> {
        FailedConnectionMap() {
        }

        @Override
        public V get(Object key) {
            throw new RuntimeException(new IOException());
        }
    }

    static class BadHttpResponseMap<K, V>
    extends HashMap<K, V> {
        BadHttpResponseMap() {
        }

        @Override
        public V get(Object key) {
            throw new RuntimeException((Throwable)new RestClientException("fail", 500, 500));
        }
    }

    static class BrokerRecord
    extends DefaultRecord {
        public BrokerRecord(byte[] key, byte[] value) {
            super(0, (byte)0, 0L, 0L, 0, key != null ? ByteBuffer.wrap(key) : null, value != null ? ByteBuffer.wrap(value) : null, new Header[0]);
        }
    }
}

