/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metrics.reporter.integration;

import io.confluent.metrics.record.ConfluentMetric;
import io.confluent.metrics.reporter.integration.MetricReporterClusterTestHarness;
import io.confluent.serializers.ProtoSerde;
import io.confluent.shaded.com.google.protobuf.GeneratedMessageV3;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetricsReporterTest
extends MetricReporterClusterTestHarness {
    protected final ProtoSerde<ConfluentMetric.MetricsMessage> serdes = new ProtoSerde((GeneratedMessageV3)ConfluentMetric.MetricsMessage.getDefaultInstance());
    protected KafkaConsumer<byte[], byte[]> consumer;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.consumer = this.createNewConsumer();
        this.consumer.subscribe(Collections.singleton("_confluent-metrics"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.consumer.close();
        super.tearDown();
    }

    @Test
    public void testMetricsReporter() {
        Result latestResult = null;
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() - startMs < 20000L) {
            ConsumerRecords records = this.consumer.poll(200L);
            Iterator i$ = records.iterator();
            while (i$.hasNext()) {
                ConsumerRecord record;
                if (!(latestResult = this.verify(latestResult == null ? new Result() : latestResult, (ConsumerRecord<byte[], byte[]>)(record = (ConsumerRecord)i$.next()))).hasAllFields()) continue;
                latestResult.verify();
                return;
            }
        }
        if (latestResult == null) {
            Assert.fail((String)"No records have been verified");
        } else {
            Assert.fail((String)String.format("One of the following is false : has Kafka measurable(%b), has Yammer gauge(%b), has Yammer Meter(%b), has Yammer histogram(%b), has Yammer Timer(%b)", latestResult.hasKafkaMeasurable, latestResult.hasYammerGauge, latestResult.hasYammerMeter, latestResult.hasYammerHistogram, latestResult.hasYammerTimer));
        }
    }

    protected Result verify(Result lastResult, ConsumerRecord<byte[], byte[]> record) {
        Result result = new Result();
        ConfluentMetric.MetricsMessage metricsMessage = (ConfluentMetric.MetricsMessage)this.serdes.deserialize((byte[])record.value());
        Assert.assertEquals((String)"metric type should be broker", (Object)ConfluentMetric.MetricType.BROKER, (Object)metricsMessage.getMetricType());
        Assert.assertTrue((String)"clusterId should be set", (!metricsMessage.getClusterId().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"clientId should not be set", (boolean)metricsMessage.getClientId().isEmpty());
        Assert.assertTrue((String)"groupId should not be set", (boolean)metricsMessage.getGroupId().isEmpty());
        Assert.assertEquals((String)"record timestamp should match metric timestamp", (long)metricsMessage.getTimestamp(), (long)record.timestamp());
        this.verifyBrokerId(metricsMessage.getBrokerId());
        result.hasKafkaMeasurable = lastResult.hasKafkaMeasurable || metricsMessage.getKafkaMeasurableCount() > 0;
        result.hasYammerGauge = lastResult.hasYammerGauge || metricsMessage.getYammerGaugeCount() > 0;
        result.hasYammerMeter = lastResult.hasYammerMeter || metricsMessage.getYammerMeterCount() > 0;
        result.hasYammerHistogram = lastResult.hasYammerHistogram || metricsMessage.getYammerHistogramCount() > 0;
        result.hasYammerTimer = lastResult.hasYammerTimer || metricsMessage.getYammerTimerCount() > 0;
        result.systemMetrics = metricsMessage.hasSystemMetrics() ? metricsMessage.getSystemMetrics() : lastResult.systemMetrics;
        return result;
    }

    protected void verifyBrokerId(int brokerId) {
        Assert.assertEquals((String)"brokerId should match", (long)1L, (long)brokerId);
    }

    private KafkaConsumer<byte[], byte[]> createNewConsumer() {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.brokerList);
        properties.put("group.id", "metric-reporter-consumer");
        properties.put("metadata.max.age.ms", "400");
        return new KafkaConsumer(properties, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    public static class Result {
        boolean hasKafkaMeasurable;
        boolean hasYammerGauge;
        boolean hasYammerMeter;
        boolean hasYammerHistogram;
        boolean hasYammerTimer;
        ConfluentMetric.SystemMetrics systemMetrics;

        boolean hasAllFields() {
            return this.hasKafkaMeasurable && this.hasYammerGauge && this.hasYammerMeter && this.hasYammerHistogram && this.hasYammerTimer && this.systemMetrics != null;
        }

        void verify() {
            List volumes = this.systemMetrics.getVolumesList();
            Assert.assertFalse((String)"Expected to find volumes.", (boolean)volumes.isEmpty());
            for (ConfluentMetric.VolumeMetrics volume : volumes) {
                Assert.assertFalse((String)"The volume name must not be empty.", (boolean)volume.getName().isEmpty());
                Assert.assertTrue((String)"Must have a positive number of total bytes.", (volume.getTotalBytes() > 0L ? 1 : 0) != 0);
                Assert.assertTrue((String)"Must have a positive number of usable bytes.", (volume.getUsableBytes() > 0L ? 1 : 0) != 0);
                Assert.assertTrue((String)"Must have more total bytes than usable bytes.", (volume.getTotalBytes() > volume.getUsableBytes() ? 1 : 0) != 0);
                Assert.assertTrue((String)"Must have at least one log directory.", (volume.getLogDirsCount() > 0 ? 1 : 0) != 0);
                for (ConfluentMetric.LogDir logDir : volume.getLogDirsList()) {
                    Assert.assertFalse((String)"The log directory path must not be empty.", (boolean)logDir.getPath().isEmpty());
                    Assert.assertTrue((String)"The log directory path must start with / (that is, be absolute.)", (boolean)logDir.getPath().startsWith("/"));
                }
            }
        }
    }
}

