/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.logging.log4j2;

import io.confluent.common.logging.LogRecordBuilder;
import io.confluent.common.logging.StructuredLogMessage;
import io.confluent.common.logging.log4j2.StructuredLayout;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.Message;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

public class StructuredLayoutTest {
    private static final String TOPIC = "topic";
    private static final Level LOG_LEVEL = Level.INFO;
    private static final String LOGGER_NAME = "foo.bar";
    private static final long LOG_TIME_MS = 123456L;
    private static final byte[] SERIALIZED_MSG = "serialized".getBytes();
    @Mock
    private Function<Struct, byte[]> converter;
    @Mock
    private LogEvent logEvent;
    @Mock
    private Message log4jMessage;
    @Mock
    private LogRecordBuilder<Struct> builder;
    @Mock
    private StructuredLogMessage logMessage;
    @Mock
    private Schema schema;
    @Mock
    private Struct struct;
    private SchemaAndValue schemaAndValue;
    private StructuredLayout layout;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void setup() {
        this.layout = new StructuredLayout(this.converter, () -> this.builder);
        Mockito.when((Object)this.logEvent.getMessage()).thenReturn((Object)this.log4jMessage);
        Mockito.when((Object)this.logEvent.getLevel()).thenReturn((Object)LOG_LEVEL);
        Mockito.when((Object)this.logEvent.getLoggerName()).thenReturn((Object)LOGGER_NAME);
        Mockito.when((Object)this.logEvent.getTimeMillis()).thenReturn((Object)123456L);
        Mockito.when((Object)this.converter.apply((Struct)ArgumentMatchers.any(Struct.class))).thenReturn((Object)SERIALIZED_MSG);
        this.schemaAndValue = new SchemaAndValue(this.schema, (Object)this.struct);
        Mockito.when((Object)this.logMessage.getMessage()).thenReturn((Object)this.schemaAndValue);
        Mockito.when((Object)this.builder.withLevel(ArgumentMatchers.anyString())).thenReturn(this.builder);
        Mockito.when((Object)this.builder.withLoggerName(ArgumentMatchers.anyString())).thenReturn(this.builder);
        Mockito.when((Object)this.builder.withMessageSchemaAndValue((SchemaAndValue)ArgumentMatchers.any(SchemaAndValue.class))).thenReturn(this.builder);
        Mockito.when((Object)this.builder.withTimeMs(ArgumentMatchers.anyLong())).thenReturn(this.builder);
        Mockito.when((Object)this.struct.schema()).thenReturn((Object)this.schema);
    }

    private void verifyBeforeBuild(LogRecordBuilder<Struct> builder, Consumer<InOrder> action) {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{builder});
        action.accept(inOrder);
        ((LogRecordBuilder)inOrder.verify(builder)).build();
    }

    @Test
    public void shouldSerializeMessageCorrectly() {
        Mockito.when((Object)this.log4jMessage.getParameters()).thenReturn((Object)new Object[]{this.logMessage});
        Schema logSchema = (Schema)Mockito.mock(Schema.class);
        Struct logRecord = (Struct)Mockito.mock(Struct.class);
        Mockito.when((Object)logRecord.schema()).thenReturn((Object)logSchema);
        Mockito.when((Object)this.builder.build()).thenReturn((Object)logRecord);
        byte[] serialized = this.layout.toByteArray(this.logEvent);
        this.verifyBeforeBuild(this.builder, io -> ((LogRecordBuilder)io.verify(this.builder)).withLoggerName(LOGGER_NAME));
        this.verifyBeforeBuild(this.builder, io -> ((LogRecordBuilder)io.verify(this.builder)).withTimeMs(123456L));
        this.verifyBeforeBuild(this.builder, io -> ((LogRecordBuilder)io.verify(this.builder)).withLevel(LOG_LEVEL.name()));
        this.verifyBeforeBuild(this.builder, io -> ((LogRecordBuilder)io.verify(this.builder)).withMessageSchemaAndValue(this.schemaAndValue));
        ((Function)Mockito.verify(this.converter, (VerificationMode)Mockito.times((int)1))).apply(logRecord);
        Assert.assertThat((Object)serialized, (Matcher)CoreMatchers.equalTo((Object)SERIALIZED_MSG));
    }

    @Test
    public void shouldThrowIfInvalidNumberParameters() {
        this.expectInvalidParameters(new Object[0]);
        this.layout.toByteArray(this.logEvent);
    }

    @Test
    public void shouldThrowIfInvalidParameterType() {
        this.expectInvalidParameters(123);
        this.layout.toByteArray(this.logEvent);
    }

    private void expectInvalidParameters(Object ... params) {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("LogEvent must contain a single parameter of type StructuredLogMessage");
        Mockito.when((Object)this.log4jMessage.getParameters()).thenReturn((Object)params);
    }
}

