/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.logging.log4j;

import io.confluent.common.logging.LogRecordBuilder;
import io.confluent.common.logging.log4j.StructuredJsonLayout;
import java.util.function.Consumer;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class StructuredJsonLayoutTest {
    private static final Level LOG_LEVEL = Level.INFO;
    private static final String LOGGER_NAME = "foo.bar";
    private static final long LOG_TIME_MS = 123456L;
    private static final String STRUCTURED_MSG = "msg";
    private static final String SERIALIZED_MSG = "serialized";
    @Mock
    private LogRecordBuilder<String> builder;
    private LoggingEvent loggingEvent;
    private StructuredJsonLayout layout;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();

    @Before
    public void setUp() {
        Mockito.when((Object)this.builder.withTimeMs(ArgumentMatchers.anyLong())).thenReturn(this.builder);
        Mockito.when((Object)this.builder.withLoggerName(ArgumentMatchers.anyString())).thenReturn(this.builder);
        Mockito.when((Object)this.builder.withLevel(ArgumentMatchers.anyString())).thenReturn(this.builder);
        Mockito.when((Object)this.builder.withMessageJson(ArgumentMatchers.anyString())).thenReturn(this.builder);
        Mockito.when((Object)this.builder.build()).thenReturn((Object)SERIALIZED_MSG);
        this.loggingEvent = new LoggingEvent("fcqn", (Category)new FakeCategory(LOGGER_NAME), 123456L, (Priority)LOG_LEVEL, (Object)STRUCTURED_MSG, null);
        this.layout = new StructuredJsonLayout(() -> this.builder);
    }

    private void verifyBeforeBuild(LogRecordBuilder<String> builder, Consumer<InOrder> action) {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{builder});
        action.accept(inOrder);
        ((LogRecordBuilder)inOrder.verify(builder)).build();
    }

    @Test
    public void shouldFormatLogRecordCorrectly() {
        String msg = this.layout.format(this.loggingEvent);
        this.verifyBeforeBuild(this.builder, io -> ((LogRecordBuilder)io.verify(this.builder)).withLevel(LOG_LEVEL.toString()));
        this.verifyBeforeBuild(this.builder, io -> ((LogRecordBuilder)io.verify(this.builder)).withTimeMs(123456L));
        this.verifyBeforeBuild(this.builder, io -> ((LogRecordBuilder)io.verify(this.builder)).withLoggerName(LOGGER_NAME));
        this.verifyBeforeBuild(this.builder, io -> ((LogRecordBuilder)io.verify(this.builder)).withMessageJson(STRUCTURED_MSG));
        Assert.assertThat((Object)msg, (Matcher)CoreMatchers.equalTo((Object)SERIALIZED_MSG));
    }

    private static class FakeCategory
    extends Category {
        private FakeCategory(String name) {
            super(name);
        }
    }
}

