/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.integration;

import io.confluent.common.security.SecureTestUtils;
import io.confluent.kafkarest.integration.ClusterTestHarness;
import io.confluent.security.integration.KafkaRestSslClusterTestHarnessUtil;
import java.util.Properties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import kafka.utils.TestUtils;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SslTopicResourceTest
extends ClusterTestHarness {
    private static final String TOPIC = "topic-1";
    private final KafkaRestSslClusterTestHarnessUtil sslUtil = new KafkaRestSslClusterTestHarnessUtil();

    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        TestUtils.waitUntilTrue(() -> this.request("/topics").get().getStatus() != 402, () -> "Fail to fetch a valid license", (long)5000L, (long)100L);
    }

    protected String getRestConnectString(int restPort) {
        return this.sslUtil.getRestConnectString(restPort);
    }

    protected void overrideKafkaRestConfigs(Properties restProperties) {
        this.sslUtil.overrideKafkaRestConfigs(restProperties);
        restProperties.put("bootstrap.servers", this.brokerList);
        restProperties.setProperty("confluent.license.bootstrap.servers", this.plaintextBrokerList);
        restProperties.setProperty("confluent.license.security.protocol", "PLAINTEXT");
    }

    protected Properties getBrokerProperties(int i) {
        return this.sslUtil.getBrokerProperties(i, this.zkConnect);
    }

    public Properties overrideBrokerProperties(int i, Properties props) {
        props.put("delete.topic.enable", (Object)true);
        return props;
    }

    protected Client getClient() {
        return this.sslUtil.getClient();
    }

    protected SecurityProtocol getBrokerSecurityProtocol() {
        return SecurityProtocol.SSL;
    }

    protected void setupAcls() {
        SecureTestUtils.addClusterACLs((String)this.zkConnect, (String)this.sslUtil.clientCerts.get(2).getSubjectX500Principal().getName(), (AclOperation[])new AclOperation[]{AclOperation.ALL});
        SecureTestUtils.addTopicACLs((String)this.zkConnect, (String)"*", (String)this.sslUtil.clientCerts.get(2).getSubjectX500Principal().getName(), (AclOperation[])new AclOperation[]{AclOperation.DESCRIBE});
        SecureTestUtils.addTopicACLs((String)this.zkConnect, (String)"*", (String)this.sslUtil.clientCerts.get(2).getSubjectX500Principal().getName(), (AclOperation[])new AclOperation[]{AclOperation.DELETE});
        SecureTestUtils.setProduceACls((String)this.zkConnect, (String)"_confluent-command", (String)KafkaPrincipal.ANONYMOUS.getName());
        SecureTestUtils.setConsumerACls((String)this.zkConnect, (String)"_confluent-command", (String)KafkaPrincipal.ANONYMOUS.getName(), (String)"*");
    }

    @Test
    public void listTopics_returnsTopic() {
        String clusterId = this.getClusterId();
        this.createTopic(TOPIC, 1, (short)1);
        Response response = this.request("/v3/clusters/" + clusterId + "/topics").accept(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertTrue((boolean)((String)response.readEntity(String.class)).contains("\"topic_name\":\"topic-1\""));
    }

    @Test
    public void listTopics_unauthorized_doesNotReturnTopic() {
        String clusterId = this.getClusterId();
        this.createTopic(TOPIC, 1, (short)1);
        Client unauthorizedClient = this.sslUtil.getClient(this.sslUtil.clientCerts.subList(0, 1), this.sslUtil.keyPairs.subList(0, 1));
        Response unauthorizedResponse = unauthorizedClient.target(this.restConnect).path("/v3/clusters/" + clusterId + "/topics").request().accept(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)unauthorizedResponse.getStatus());
        Assertions.assertFalse((boolean)((String)unauthorizedResponse.readEntity(String.class)).contains(TOPIC));
        Client authorizedClient = this.sslUtil.getClient(this.sslUtil.clientCerts.subList(2, 3), this.sslUtil.keyPairs.subList(2, 3));
        Response authorizedResponse = authorizedClient.target(this.restConnect).path("/v3/clusters/" + clusterId + "/topics").request().accept(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)authorizedResponse.getStatus());
        Assertions.assertTrue((boolean)((String)authorizedResponse.readEntity(String.class)).contains(TOPIC));
    }

    @Test
    public void getTopic_returnsTopic() {
        String clusterId = this.getClusterId();
        this.createTopic(TOPIC, 1, (short)1);
        Response response = this.request("/v3/clusters/" + clusterId + "/topics/" + TOPIC).accept(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertTrue((boolean)((String)response.readEntity(String.class)).contains("\"topic_name\":\"topic-1\""));
    }

    @Test
    public void createTopic_createsTopic() {
        String clusterId = this.getClusterId();
        Response response = this.request("/v3/clusters/" + clusterId + "/topics").accept(new String[]{"application/json"}).post(Entity.entity((Object)"{\"topic_name\":\"topic-1\",\"partitions_count\":1,\"replication_factor\":1}", (String)"application/json"));
        Assertions.assertEquals((int)Response.Status.CREATED.getStatusCode(), (int)response.getStatus());
        Assertions.assertTrue((boolean)this.getTopicNames().contains(TOPIC));
    }

    @Test
    public void deleteTopic_deletesTopic() {
        String clusterId = this.getClusterId();
        this.createTopic(TOPIC, 1, (short)1);
        Response response = this.request("/v3/clusters/" + clusterId + "/topics/" + TOPIC).accept(new String[]{"application/json"}).delete();
        Assertions.assertEquals((int)Response.Status.NO_CONTENT.getStatusCode(), (int)response.getStatus());
        Assertions.assertTrue((boolean)((String)response.readEntity(String.class)).isEmpty());
        Assertions.assertFalse((boolean)this.getTopicNames().contains(TOPIC));
    }
}

