/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.integration;

import io.confluent.common.security.SecureTestUtils;
import io.confluent.kafkarest.integration.JsonProducerTest;
import io.confluent.security.integration.KafkaRestSslClusterTestHarnessUtil;
import java.util.Properties;
import javax.ws.rs.client.Client;
import kafka.utils.TestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class SslJsonProducerTest
extends JsonProducerTest {
    private KafkaRestSslClusterTestHarnessUtil kafkaRestSslClusterTestHarnessUtil = new KafkaRestSslClusterTestHarnessUtil();

    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        TestUtils.waitUntilTrue(() -> this.request("/topics").get().getStatus() != 402, () -> "Fail to fetch a valid license", (long)5000L, (long)100L);
    }

    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected String getRestConnectString(int restPort) {
        return this.kafkaRestSslClusterTestHarnessUtil.getRestConnectString(restPort);
    }

    protected void overrideKafkaRestConfigs(Properties restProperties) {
        this.kafkaRestSslClusterTestHarnessUtil.overrideKafkaRestConfigs(restProperties);
        restProperties.put("bootstrap.servers", this.brokerList);
        restProperties.setProperty("confluent.license.bootstrap.servers", this.plaintextBrokerList);
        restProperties.setProperty("confluent.license.security.protocol", "PLAINTEXT");
    }

    protected Properties getBrokerProperties(int i) {
        return this.kafkaRestSslClusterTestHarnessUtil.getBrokerProperties(i, this.zkConnect);
    }

    protected Client getClient() {
        return this.kafkaRestSslClusterTestHarnessUtil.getClient();
    }

    protected SecurityProtocol getBrokerSecurityProtocol() {
        return SecurityProtocol.SSL;
    }

    protected void setupAcls() {
        SecureTestUtils.setProduceACls((String)this.zkConnect, (String)"topic1", (String)this.kafkaRestSslClusterTestHarnessUtil.clientCerts.get(2).getSubjectX500Principal().getName());
        SecureTestUtils.setConsumerACls((String)this.zkConnect, (String)"topic1", (String)"*", (String)"*");
        SecureTestUtils.setProduceACls((String)this.zkConnect, (String)"_confluent-command", (String)KafkaPrincipal.ANONYMOUS.getName());
        SecureTestUtils.setConsumerACls((String)this.zkConnect, (String)"_confluent-command", (String)KafkaPrincipal.ANONYMOUS.getName(), (String)"*");
    }
}

