/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.integration;

import io.confluent.common.security.SecureTestUtils;
import io.confluent.kafkarest.security.KafkaRestSecurityResourceExtension;
import io.confluent.security.integration.KafkaRestSslClusterTestHarnessUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Option;

public class KafkaRestSaslClusterTestHarnessUtil
extends KafkaRestSslClusterTestHarnessUtil {
    Properties brokerProps;

    @Override
    protected void overrideKafkaRestConfigs(Properties restProperties) {
        restProperties.putAll((Map<?, ?>)this.clientSslConfigs);
        for (Map.Entry<Object, Object> entry : this.clientSslConfigs.entrySet()) {
            restProperties.put("client." + entry.getKey(), entry.getValue());
        }
        restProperties.put("confluent.rest.auth.propagate.method", "SSL");
        restProperties.put("kafka.rest.resource.extension.class", KafkaRestSecurityResourceExtension.class.getName());
        restProperties.put("client.security.protocol", "SASL_PLAINTEXT");
        restProperties.put("client.sasl.mechanism", "PLAIN");
        restProperties.put("security.protocol", "SASL_PLAINTEXT");
        restProperties.put("client.sasl.kerberos.service.name", "kafka");
        restProperties.put("ssl.client.auth", (Object)true);
        restProperties.put("ssl.endpoint.identification.algorithm", "");
        restProperties.put("http2.enabled", (Object)false);
    }

    @Override
    protected Properties getBrokerProperties(int i, String zkConnect) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.brokerProps);
        props.put(KafkaConfig.BrokerIdProp(), Integer.toString(i));
        props.put(KafkaConfig.ZkConnectProp(), zkConnect);
        return props;
    }

    public void init() {
        File trustStoreFile;
        try {
            trustStoreFile = File.createTempFile("SSLClusterTestHarness-truststore", ".jks");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create temporary file for the truststore.");
        }
        Option trustStoreFileOption = Option.apply((Object)trustStoreFile);
        Option securityProtocolOption = Option.apply((Object)SecurityProtocol.SASL_PLAINTEXT);
        Properties saslprops = new Properties();
        saslprops.setProperty("sasl.enabled.mechanisms", "PLAIN");
        saslprops.setProperty("sasl.mechanism.inter.broker.protocol", "PLAIN");
        Option SASL_PROPERTIES = Option.apply((Object)saslprops);
        this.brokerProps = TestUtils.createBrokerConfig((int)0, (String)"", (boolean)false, (boolean)false, (int)TestUtils.RandomPort(), (Option)securityProtocolOption, (Option)trustStoreFileOption, (Option)SASL_PROPERTIES, (boolean)true, (boolean)true, (int)TestUtils.RandomPort(), (boolean)true, (int)TestUtils.RandomPort(), (boolean)false, (int)TestUtils.RandomPort(), (Option)Option.empty(), (int)1, (boolean)false, (int)1, (short)1, (boolean)false);
        try {
            this.clientSslConfigs = SecureTestUtils.clientSslConfigsWithKeyStore((int)3, (File)trustStoreFile, (Password)new Password((String)this.brokerProps.get("ssl.truststore.password")), (List)this.clientCerts, (List)this.keyPairs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.brokerProps.setProperty("auto.create.topics.enable", "true");
        this.brokerProps.setProperty("num.partitions", "1");
        this.brokerProps.setProperty("authorizer.class.name", AclAuthorizer.class.getName());
        this.brokerProps.setProperty("super.users", "User:superuser");
        try {
            File jaasConfigFile = File.createTempFile("ks-jaas-", ".conf");
            jaasConfigFile.deleteOnExit();
            System.setProperty("java.security.auth.login.config", jaasConfigFile.getPath());
            System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("KafkaServer { org.apache.kafka.common.security.plain.PlainLoginModule required username=superuser password=superpwd user_superuser=superpwd \"user_" + ((X509Certificate)this.clientCerts.get(2)).getSubjectX500Principal().getName() + "\"=\"password1\";};");
            lines.add("KafkaClient { org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + ((X509Certificate)this.clientCerts.get(2)).getSubjectX500Principal().getName() + "\" password=\"password1\";};");
            lines.add("Client {    org.apache.zookeeper.server.auth.DigestLoginModule optional     username=\"admin\"     password=\"admin-secret\";     };");
            lines.add("Server {    org.apache.zookeeper.server.auth.DigestLoginModule optional     user_admin=\"admin-secret\";     };");
            Files.write(jaasConfigFile.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
            Configuration.setConfiguration(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clean() {
        Configuration.setConfiguration(null);
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty("zookeeper.authProvider.1");
    }
}

