/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.integration;

import com.google.common.io.BaseEncoding;
import io.confluent.common.security.SecureTestUtils;
import io.confluent.kafkarest.entities.v2.JsonPartitionProduceRequest;
import io.confluent.kafkarest.entities.v2.JsonTopicProduceRequest;
import io.confluent.kafkarest.integration.AbstractProducerTest;
import io.confluent.security.integration.KafkaRestSslClusterTestHarnessUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Properties;
import javax.ws.rs.client.Client;
import kafka.utils.TestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class InvalidSslUserProducerTest
extends AbstractProducerTest<JsonTopicProduceRequest, JsonPartitionProduceRequest> {
    private KafkaRestSslClusterTestHarnessUtil kafkaRestSslClusterTestHarnessUtil = new KafkaRestSslClusterTestHarnessUtil();

    @Before
    public void setUp() throws Exception {
        super.setUp();
        TestUtils.waitUntilTrue(() -> this.request("/topics").get().getStatus() != 402, () -> "Fail to fetch a valid license", (long)5000L, (long)100L);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testInvalidUserJsonProducer() {
        this.testProduceToAuthorizationError("topic1", JsonTopicProduceRequest.create(Collections.singletonList(new JsonTopicProduceRequest.JsonTopicProduceRecord((Object)"value", (Object)0, null))), "application/vnd.kafka.json.v2+json");
    }

    @Test
    public void testInvalidUserBinaryProducer() {
        this.testProduceToAuthorizationError("topic1", JsonTopicProduceRequest.create(Collections.singletonList(new JsonTopicProduceRequest.JsonTopicProduceRecord((Object)BaseEncoding.base64().encode("value".getBytes(StandardCharsets.UTF_8)), (Object)BaseEncoding.base64().encode(String.valueOf(0).getBytes(StandardCharsets.UTF_8)), null))), "application/vnd.kafka.binary.v2+json");
    }

    protected String getRestConnectString(int restPort) {
        return this.kafkaRestSslClusterTestHarnessUtil.getRestConnectString(restPort);
    }

    protected void overrideKafkaRestConfigs(Properties restProperties) {
        this.kafkaRestSslClusterTestHarnessUtil.overrideKafkaRestConfigs(restProperties);
        restProperties.put("bootstrap.servers", this.brokerList);
        restProperties.setProperty("client.metadata.fetch.timeout.ms", "5000");
        restProperties.setProperty("client.max.block.ms", "5000");
        restProperties.setProperty("confluent.license.bootstrap.servers", this.plaintextBrokerList);
        restProperties.setProperty("confluent.license.security.protocol", "PLAINTEXT");
    }

    protected Properties getBrokerProperties(int i) {
        return this.kafkaRestSslClusterTestHarnessUtil.getBrokerProperties(i, this.zkConnect);
    }

    protected Client getClient() {
        return this.kafkaRestSslClusterTestHarnessUtil.getClient();
    }

    protected SecurityProtocol getBrokerSecurityProtocol() {
        return SecurityProtocol.SSL;
    }

    protected void setupAcls() {
        SecureTestUtils.setProduceACls((String)this.zkConnect, (String)"topic1", (String)this.kafkaRestSslClusterTestHarnessUtil.clientCerts.get(1).getSubjectX500Principal().getName());
        SecureTestUtils.setConsumerACls((String)this.zkConnect, (String)"topic1", (String)"*", (String)"*");
        SecureTestUtils.setProduceACls((String)this.zkConnect, (String)"_confluent-command", (String)KafkaPrincipal.ANONYMOUS.getName());
        SecureTestUtils.setConsumerACls((String)this.zkConnect, (String)"_confluent-command", (String)KafkaPrincipal.ANONYMOUS.getName(), (String)"*");
    }
}

