/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.config;

import io.confluent.common.security.auth.RestSecurityContext;
import io.confluent.common.security.auth.RestUserPrincipal;
import io.confluent.kafkarest.security.config.ConfluentSecureKafkaRestConfig;
import io.confluent.kafkarest.security.config.SaslSecureConfigProvider;
import io.confluent.rest.RestConfigException;
import java.net.URL;
import java.security.Principal;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.Configuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SaslSecureConfigProviderTest {
    SaslSecureConfigProvider saslSecureConfigProvider;

    @Before
    public void setup() {
        URL confFile = this.getClass().getResource("/test-jaas-config.conf");
        System.setProperty("java.security.auth.login.config", confFile.getFile());
        Configuration.setConfiguration(null);
        this.saslSecureConfigProvider = new SaslSecureConfigProvider();
    }

    @Test
    public void testGetWithDefaultMechanismForKrb5() {
        this.runInNewThread("kafka-client-1@EXAMPLE.COM", "SSL", "GSSAPI");
    }

    @Test
    public void testGetWithDefaultMechanismForPlain() {
        this.runInNewThread("alice-plain", "SSL", "PLAIN");
    }

    @Test
    public void testGetWithDefaultMechanismForScram() {
        this.runInNewThread("alice-scram", "SSL", "SCRAM-SHA-512");
    }

    @Test
    public void testGetWithOverrideMechanismForScram() {
        this.runInNewThread("alice-scram-256", "SSL", "SCRAM-SHA-256");
    }

    private void getAndAssertMechanism(String expectedMechanism) throws RestConfigException {
        Properties consumerProps = this.saslSecureConfigProvider.getConsumerProperties(new ConfluentSecureKafkaRestConfig(new Properties(), Optional.empty()));
        Properties producerProps = this.saslSecureConfigProvider.getConsumerProperties(new ConfluentSecureKafkaRestConfig(new Properties(), Optional.empty()));
        Assert.assertNotNull((Object)consumerProps);
        Assert.assertNotNull((Object)producerProps);
        Assert.assertEquals((Object)producerProps, (Object)consumerProps);
        Assert.assertEquals((String)"Mechanism matches", (Object)expectedMechanism, (Object)producerProps.get("sasl.mechanism"));
    }

    private void runInNewThread(String user, String authScheme, String expectedMechanism) {
        Thread shortLivedThread = new Thread(() -> {
            Class<RestSecurityContext> clazz = RestSecurityContext.class;
            synchronized (RestSecurityContext.class) {
                try {
                    new RestSecurityContext((Principal)new RestUserPrincipal(user), authScheme);
                    this.getAndAssertMechanism(expectedMechanism);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    RestSecurityContext.clear();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        });
        shortLivedThread.start();
        try {
            shortLivedThread.join(TimeUnit.SECONDS.toMillis(5L));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Thread join failed with: ", e);
        }
    }
}

