/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.config;

import io.confluent.kafkarest.security.config.ConfluentSecureKafkaRestConfig;
import io.confluent.rest.RestConfigException;
import java.util.Optional;
import java.util.Properties;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;

public class KafkaRestConfigTest {
    private String clientSslTruststore = "client.truststore.jks";
    private String clientSslKeystore = "client.keystore.jks";
    private String mdsSslTruststore = "mds.truststore.jks";
    private String mdsSslKeystore = "mds.keystore.jks";

    @Test
    public void testClientConfiguration() throws RestConfigException {
        Properties props = new Properties();
        props.put("ssl.keystore.location", "test.keystore.jks");
        props.put("ssl.truststore.location", "test.truststore.jks");
        props.put("client.security.protocol", "SASL_SSL");
        props.put("client.ssl.keystore.location", this.clientSslKeystore);
        props.put("client.ssl.truststore.location", this.clientSslTruststore);
        props.put("confluent.metadata.rest.client.ssl.keystore.location", this.mdsSslKeystore);
        props.put("confluent.metadata.rest.client.ssl.truststore.location", this.mdsSslTruststore);
        ConfluentSecureKafkaRestConfig restConfig = new ConfluentSecureKafkaRestConfig(props, Optional.of("token12345"));
        this.validateConfigs(restConfig.getProducerProperties());
        this.validateConfigs(restConfig.getConsumerProperties());
        this.validateConfigs(restConfig.getAdminProperties());
    }

    private void validateConfigs(Properties props) {
        Assert.assertEquals((Object)"SASL_SSL", (Object)props.get("security.protocol"));
        Assert.assertEquals((Object)this.clientSslKeystore, (Object)props.get("ssl.keystore.location"));
        Assert.assertEquals((Object)this.clientSslTruststore, (Object)props.get("ssl.truststore.location"));
        Assert.assertEquals((Object)"OAUTHBEARER", (Object)props.get("sasl.mechanism"));
        Assert.assertEquals((Object)"io.confluent.kafka.clients.plugins.auth.token.TokenBearerLoginCallbackHandler", (Object)props.get("sasl.login.callback.handler.class"));
        TestCase.assertTrue((boolean)((String)props.get("sasl.jaas.config")).contains("token12345"));
        Assert.assertEquals((Object)"MDS", (Object)props.get("bearer.auth.credentials.source"));
        Assert.assertEquals((Object)this.mdsSslKeystore, (Object)props.get("confluent.metadata.rest.client.ssl.keystore.location"));
        Assert.assertEquals((Object)this.mdsSslTruststore, (Object)props.get("confluent.metadata.rest.client.ssl.truststore.location"));
    }
}

