/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.integration;

import com.google.common.collect.ImmutableList;
import io.confluent.common.security.SecureTestUtils;
import io.confluent.security.integration.AbstractMissingUserProducerTest;
import io.confluent.security.integration.KafkaRestSslClusterTestHarnessUtil;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.client.Client;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class SslMissingUserProducerTest
extends AbstractMissingUserProducerTest {
    private KafkaRestSslClusterTestHarnessUtil kafkaRestSslClusterTestHarnessUtil = new KafkaRestSslClusterTestHarnessUtil();

    protected String getRestConnectString(int restPort) {
        return this.kafkaRestSslClusterTestHarnessUtil.getRestConnectString(restPort);
    }

    protected void overrideKafkaRestConfigs(Properties restProperties) {
        this.kafkaRestSslClusterTestHarnessUtil.overrideKafkaRestConfigs(restProperties);
        restProperties.put("bootstrap.servers", this.brokerList);
        restProperties.setProperty("client.metadata.fetch.timeout.ms", "5000");
        restProperties.setProperty("client.max.block.ms", "5000");
        restProperties.setProperty("confluent.license.bootstrap.servers", this.plaintextBrokerList);
        restProperties.setProperty("confluent.license.security.protocol", "PLAINTEXT");
    }

    protected Properties getBrokerProperties(int i) {
        Properties brokerProps = this.kafkaRestSslClusterTestHarnessUtil.getBrokerProperties(i, this.zkConnect);
        this.setupClientCerts(this.kafkaRestSslClusterTestHarnessUtil.clientSslConfigs.getProperty("ssl.truststore.location"), this.kafkaRestSslClusterTestHarnessUtil.clientSslConfigs.getProperty("ssl.truststore.password"));
        return brokerProps;
    }

    protected Client getClient() {
        return this.kafkaRestSslClusterTestHarnessUtil.getClient((List<X509Certificate>)ImmutableList.of((Object)this.cert), (List<KeyPair>)ImmutableList.of((Object)this.kp));
    }

    protected SecurityProtocol getBrokerSecurityProtocol() {
        return SecurityProtocol.SSL;
    }

    protected void setupAcls() {
        SecureTestUtils.setProduceACls((String)this.zkConnect, (String)"topic1", (String)this.kafkaRestSslClusterTestHarnessUtil.clientCerts.get(1).getSubjectX500Principal().getName());
        SecureTestUtils.setConsumerACls((String)this.zkConnect, (String)"topic1", (String)"*", (String)"*");
        SecureTestUtils.setProduceACls((String)this.zkConnect, (String)"_confluent-command", (String)KafkaPrincipal.ANONYMOUS.getName());
        SecureTestUtils.setConsumerACls((String)this.zkConnect, (String)"_confluent-command", (String)KafkaPrincipal.ANONYMOUS.getName(), (String)"*");
    }
}

