/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.integration;

import com.google.common.collect.ImmutableList;
import io.confluent.common.security.SecureTestUtils;
import io.confluent.security.integration.AbstractMissingUserProducerTest;
import io.confluent.security.integration.KafkaRestSaslClusterTestHarnessUtil;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.client.Client;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Before;

public class SaslMissingUserProducerTest
extends AbstractMissingUserProducerTest {
    private KafkaRestSaslClusterTestHarnessUtil kafkaRestSaslClusterTestHarnessUtil = new KafkaRestSaslClusterTestHarnessUtil();

    @Override
    @Before
    public void setUp() throws Exception {
        this.kafkaRestSaslClusterTestHarnessUtil.init();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.kafkaRestSaslClusterTestHarnessUtil.clean();
        super.tearDown();
    }

    protected String getRestConnectString(int restPort) {
        return this.kafkaRestSaslClusterTestHarnessUtil.getRestConnectString(restPort);
    }

    protected void overrideKafkaRestConfigs(Properties restProperties) {
        this.kafkaRestSaslClusterTestHarnessUtil.overrideKafkaRestConfigs(restProperties);
        restProperties.put("bootstrap.servers", this.brokerList);
        restProperties.setProperty("client.metadata.fetch.timeout.ms", "5000");
        restProperties.setProperty("client.max.block.ms", "5000");
        restProperties.setProperty("confluent.license.bootstrap.servers", this.plaintextBrokerList);
        restProperties.setProperty("confluent.license.security.protocol", "PLAINTEXT");
    }

    protected Properties getBrokerProperties(int i) {
        Properties brokerProps = this.kafkaRestSaslClusterTestHarnessUtil.getBrokerProperties(i, this.zkConnect);
        this.setupClientCerts(this.kafkaRestSaslClusterTestHarnessUtil.clientSslConfigs.getProperty("ssl.truststore.location"), this.kafkaRestSaslClusterTestHarnessUtil.clientSslConfigs.getProperty("ssl.truststore.password"));
        return brokerProps;
    }

    protected Client getClient() {
        return this.kafkaRestSaslClusterTestHarnessUtil.getClient((List<X509Certificate>)ImmutableList.of((Object)this.cert), (List<KeyPair>)ImmutableList.of((Object)this.kp));
    }

    protected SecurityProtocol getBrokerSecurityProtocol() {
        return SecurityProtocol.SSL;
    }

    protected void setupAcls() {
        SecureTestUtils.setProduceACls((String)this.zkConnect, (String)"topic1", (String)((X509Certificate)this.kafkaRestSaslClusterTestHarnessUtil.clientCerts.get(1)).getSubjectX500Principal().getName());
        SecureTestUtils.setConsumerACls((String)this.zkConnect, (String)"topic1", (String)"*", (String)"*");
        SecureTestUtils.setProduceACls((String)this.zkConnect, (String)"_confluent-command", (String)KafkaPrincipal.ANONYMOUS.getName());
        SecureTestUtils.setConsumerACls((String)this.zkConnect, (String)"_confluent-command", (String)KafkaPrincipal.ANONYMOUS.getName(), (String)"*");
    }
}

