/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.integration;

import io.confluent.common.security.SecureTestUtils;
import io.confluent.kafkarest.entities.v2.BinaryTopicProduceRequest;
import io.confluent.kafkarest.integration.ProducerTest;
import io.confluent.security.integration.KafkaRestSaslClusterTestHarnessUtil;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.client.Client;
import kafka.utils.TestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class SaslBinaryProducerTest
extends ProducerTest {
    private final List<BinaryTopicProduceRequest.BinaryTopicProduceRecord> topicRecordsWithKeys = Collections.singletonList(new BinaryTopicProduceRequest.BinaryTopicProduceRecord("key", "value", null));
    private KafkaRestSaslClusterTestHarnessUtil kafkaRestSaslClusterTestHarnessUtil = new KafkaRestSaslClusterTestHarnessUtil();

    @Before
    public void setUp() throws Exception {
        this.kafkaRestSaslClusterTestHarnessUtil.init();
        super.setUp();
        TestUtils.waitUntilTrue(() -> this.request("/topics").get().getStatus() != 402, () -> "Fail to fetch a valid license", (long)5000L, (long)100L);
    }

    @After
    public void tearDown() throws Exception {
        this.kafkaRestSaslClusterTestHarnessUtil.clean();
        super.tearDown();
    }

    protected String getRestConnectString(int restPort) {
        return this.kafkaRestSaslClusterTestHarnessUtil.getRestConnectString(restPort);
    }

    protected void overrideKafkaRestConfigs(Properties restProperties) {
        this.kafkaRestSaslClusterTestHarnessUtil.overrideKafkaRestConfigs(restProperties);
        restProperties.put("bootstrap.servers", this.brokerList);
        restProperties.setProperty("client.metadata.fetch.timeout.ms", "5000");
        restProperties.setProperty("client.max.block.ms", "5000");
        restProperties.setProperty("confluent.license.bootstrap.servers", this.plaintextBrokerList);
        restProperties.setProperty("confluent.license.security.protocol", "PLAINTEXT");
    }

    protected Properties getBrokerProperties(int i) {
        return this.kafkaRestSaslClusterTestHarnessUtil.getBrokerProperties(i, this.zkConnect);
    }

    protected Client getClient() {
        return this.kafkaRestSaslClusterTestHarnessUtil.getClient();
    }

    protected SecurityProtocol getBrokerSecurityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    @Test
    public void testProduceToInvalidTopic() {
        this.testProduceToAuthorizationError("invalid-topic", BinaryTopicProduceRequest.create(this.topicRecordsWithKeys));
    }

    protected void setupAcls() {
        SecureTestUtils.setProduceACls((String)this.zkConnect, (String)"topic1", (String)((X509Certificate)this.kafkaRestSaslClusterTestHarnessUtil.clientCerts.get(2)).getSubjectX500Principal().getName());
        SecureTestUtils.setConsumerACls((String)this.zkConnect, (String)"topic1", (String)"*", (String)"*");
        SecureTestUtils.setProduceACls((String)this.zkConnect, (String)"_confluent-command", (String)KafkaPrincipal.ANONYMOUS.getName());
        SecureTestUtils.setConsumerACls((String)this.zkConnect, (String)"_confluent-command", (String)KafkaPrincipal.ANONYMOUS.getName(), (String)"*");
    }

    @Ignore
    @Test
    public void testProducerConfigOverrides() {
    }
}

