/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.integration;

import io.confluent.common.security.SecureTestUtils;
import io.confluent.kafkarest.security.KafkaRestSecurityResourceExtension;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.utils.TestUtils;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.glassfish.jersey.SslConfigurator;
import scala.Option;
import scala.Option$;

public class KafkaRestSslClusterTestHarnessUtil {
    public Properties clientSslConfigs;
    public List<X509Certificate> clientCerts = new ArrayList<X509Certificate>();
    public List<KeyPair> keyPairs = new ArrayList<KeyPair>();

    protected String getRestConnectString(int restPort) {
        return String.format("https://localhost:%d", restPort);
    }

    protected void overrideKafkaRestConfigs(Properties restProperties) {
        restProperties.putAll((Map<?, ?>)this.clientSslConfigs);
        for (Map.Entry<Object, Object> entry : this.clientSslConfigs.entrySet()) {
            restProperties.put("client." + entry.getKey(), entry.getValue());
        }
        restProperties.put("confluent.rest.auth.propagate.method", "SSL");
        restProperties.put("kafka.rest.resource.extension.class", KafkaRestSecurityResourceExtension.class.getName());
        restProperties.put("ssl.client.auth", (Object)true);
        restProperties.put("ssl.endpoint.identification.algorithm", "");
    }

    protected Properties getBrokerProperties(int i, String zkConnect) {
        File trustStoreFile;
        try {
            trustStoreFile = File.createTempFile("SSLClusterTestHarness-truststore", ".jks");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create temporary file for the truststore.");
        }
        Option trustStoreFileOption = Option.apply((Object)trustStoreFile);
        Option sslInterBrokerSecurityProtocol = Option.apply((Object)SecurityProtocol.SSL);
        Option EMPTY_SASL_PROPERTIES = Option$.MODULE$.empty();
        Properties props = TestUtils.createBrokerConfig((int)i, (String)zkConnect, (boolean)false, (boolean)false, (int)TestUtils.RandomPort(), (Option)sslInterBrokerSecurityProtocol, (Option)trustStoreFileOption, (Option)EMPTY_SASL_PROPERTIES, (boolean)true, (boolean)false, (int)TestUtils.RandomPort(), (boolean)true, (int)TestUtils.RandomPort(), (boolean)false, (int)TestUtils.RandomPort(), (Option)Option.empty(), (int)1, (boolean)false, (int)1, (short)1);
        try {
            this.clientSslConfigs = SecureTestUtils.clientSslConfigsWithKeyStore((int)3, (File)trustStoreFile, (Password)((Password)props.get("ssl.truststore.password")), this.clientCerts, this.keyPairs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        props.setProperty("ssl.client.auth", "required");
        props.setProperty("auto.create.topics.enable", "true");
        props.setProperty("num.partitions", "1");
        props.setProperty("authorizer.class.name", SimpleAclAuthorizer.class.getName());
        props.setProperty("super.users", "User:O=A server,CN=localhost");
        return props;
    }

    protected Client getClient() {
        int lastIndex = this.clientCerts.size() - 1;
        List<X509Certificate> clientCerts = this.clientCerts.subList(lastIndex, lastIndex + 1);
        List<KeyPair> keyPairs = this.keyPairs.subList(lastIndex, lastIndex + 1);
        return this.getClient(clientCerts, keyPairs);
    }

    protected Client getClient(List<X509Certificate> clientCerts, List<KeyPair> keyPairs) {
        File clientKSFile = null;
        String keyStorePassword = new Password("Client-KS-Password").value();
        try {
            clientKSFile = File.createTempFile("client-Keystore", ".jks");
            SecureTestUtils.createKeyStore((File)clientKSFile, (String)keyStorePassword, clientCerts, keyPairs);
        }
        catch (Exception e) {
            new RuntimeException(e);
        }
        SslConfigurator sslConfig = SslConfigurator.newInstance().trustStoreFile(this.clientSslConfigs.getProperty("ssl.truststore.location")).trustStorePassword(this.clientSslConfigs.getProperty("ssl.truststore.password")).keyStoreFile(clientKSFile.getAbsolutePath()).keyPassword(keyStorePassword).securityProtocol("TLSv1.2");
        SSLContext sslContext = sslConfig.createSSLContext();
        Client client = ClientBuilder.newBuilder().sslContext(sslContext).build();
        return client;
    }
}

