/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.integration;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafkarest.TestUtils;
import io.confluent.kafkarest.entities.v2.JsonPartitionProduceRequest;
import io.confluent.kafkarest.entities.v2.JsonTopicProduceRequest;
import io.confluent.kafkarest.integration.AbstractProducerTest;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.test.TestSslUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractMissingUserProducerTest
extends AbstractProducerTest<JsonTopicProduceRequest, JsonPartitionProduceRequest> {
    protected KeyPair kp;
    protected X509Certificate cert;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        kafka.utils.TestUtils.waitUntilTrue(() -> this.request("/topics").get().getStatus() != 402, () -> "Fail to fetch a valid license", (long)5000L, (long)100L);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testInvalidUserJsonProducer() {
        this.testProduceToTopicFailsAuth("topic1", JsonTopicProduceRequest.create(Arrays.asList(new JsonTopicProduceRequest.JsonTopicProduceRecord((Object)"value", (Object)0, null))));
    }

    @Test
    public void testInvalidUserBinaryProducer() {
        this.testProduceToTopicFailsAuth("topic1", JsonTopicProduceRequest.create(Arrays.asList(new JsonTopicProduceRequest.JsonTopicProduceRecord((Object)"value", (Object)0, null))));
    }

    @Test
    public void testInvalidUserGetTopic() {
        Response response = this.request("/topics").get();
        TestUtils.assertErrorResponse((Response.StatusType)Response.Status.UNAUTHORIZED, (Response)response, (int)401, (String)"Principal not found", (String)"application/vnd.kafka.v2+json");
    }

    protected void testProduceToTopicFailsAuth(String topicName, JsonTopicProduceRequest request) {
        Response response = this.request("/topics/" + topicName).post(Entity.entity((Object)request, (String)"application/vnd.kafka.json.v2+json"));
        TestUtils.assertErrorResponse((Response.StatusType)Response.Status.UNAUTHORIZED, (Response)response, (int)401, (String)"Principal not found", (String)"application/vnd.kafka.v2+json");
    }

    protected void setupClientCerts(String tsLocation, String tsPassword) {
        try {
            this.kp = TestSslUtils.generateKeyPair((String)"RSA");
            this.cert = TestSslUtils.generateCertificate((String)"CN=localhost, O=MissingClient", (KeyPair)this.kp, (int)30, (String)"SHA1withRSA");
            TestSslUtils.createTrustStore((String)tsLocation, (Password)new Password(tsPassword), (Map)ImmutableMap.of((Object)"MissingClient", (Object)this.cert));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

