/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security;

import io.confluent.common.security.auth.AuthenticationFilter;
import io.confluent.common.security.auth.RestSecurityContext;
import io.confluent.common.security.auth.RestUserPrincipal;
import io.confluent.common.security.license.LicenseValidatorFilter;
import io.confluent.kafka.test.cluster.EmbeddedKafkaCluster;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.security.KafkaRestSecurityResourceExtension;
import io.confluent.license.LicenseManager;
import java.security.KeyPair;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import kafka.utils.TestUtils;
import org.apache.kafka.test.TestSslUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KafkaRestSecurityResourceExtensionTest {
    private static final int LICENSE_FETCHER_INIT_TIMEOUT_MS = 5000;
    private static final int LICENSE_FETCHER_DELAY_MS = 50;
    private EmbeddedKafkaCluster kafkaCluster;
    private String bootstrapServers;

    @Before
    public void setupKafkaCluster() throws Exception {
        this.kafkaCluster = new EmbeddedKafkaCluster();
        this.kafkaCluster.startZooKeeper();
        this.kafkaCluster.startBrokers(1, new Properties());
        this.bootstrapServers = this.kafkaCluster.bootstrapServers();
    }

    @After
    public void shutdownKafkaCluster() {
        this.kafkaCluster.shutdown();
    }

    @After
    public void teardown() {
        RestSecurityContext.clear();
    }

    @Test
    public void testRegisteredSslPrincipalMapper() throws Exception {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("confluent.rest.auth.ssl.principal.mapping.rules", "RULE:^CN=(.*?)$/$1/");
        KafkaRestConfig restConfig = new KafkaRestConfig(props);
        Configurable mockConfigurable = (Configurable)Mockito.mock(Configurable.class);
        AtomicReference authFilter = new AtomicReference();
        Mockito.when((Object)mockConfigurable.register(Mockito.any(Object.class))).then(invocationOnMock -> {
            if (invocationOnMock.getArguments()[0] instanceof AuthenticationFilter) {
                authFilter.set((AuthenticationFilter)invocationOnMock.getArguments()[0]);
            }
            return mockConfigurable;
        });
        KafkaRestSecurityResourceExtension ext = new KafkaRestSecurityResourceExtension();
        ext.register(mockConfigurable, restConfig);
        Assert.assertNotNull(authFilter.get());
        String distinguishedName = "CN=restproxy/localhost@EXAMPLE.COM";
        KeyPair keypair = TestSslUtils.generateKeyPair((String)"RSA");
        X509Certificate cert = TestSslUtils.generateCertificate((String)distinguishedName, (KeyPair)keypair, (int)30, (String)"SHA1withRSA");
        ContainerRequestContext mockContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        Mockito.when((Object)mockContext.getProperty("javax.servlet.request.X509Certificate")).thenReturn((Object)new X509Certificate[]{cert});
        Mockito.when((Object)mockContext.getSecurityContext()).thenReturn((Object)new SecurityContext(){

            public Principal getUserPrincipal() {
                return new RestUserPrincipal("test");
            }

            public boolean isUserInRole(String s) {
                return false;
            }

            public boolean isSecure() {
                return false;
            }

            public String getAuthenticationScheme() {
                return null;
            }
        });
        ArgumentCaptor securityContextCaptor = ArgumentCaptor.forClass(SecurityContext.class);
        ((ContainerRequestContext)Mockito.doNothing().when((Object)mockContext)).setSecurityContext((SecurityContext)securityContextCaptor.capture());
        ((AuthenticationFilter)authFilter.get()).filter(mockContext);
        SecurityContext securityContext = (SecurityContext)securityContextCaptor.getValue();
        Assert.assertNotNull((Object)securityContext);
        Assert.assertEquals((Object)"restproxy/localhost@EXAMPLE.COM", (Object)securityContext.getUserPrincipal().getName());
        Assert.assertEquals((Object)"SSL", (Object)securityContext.getAuthenticationScheme());
    }

    @Test
    public void testInvalidLicense() throws Exception {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("confluent.license", "invalid-license");
        KafkaRestConfig restConfig = new KafkaRestConfig(props);
        Configurable mockConfigurable = (Configurable)Mockito.mock(Configurable.class);
        AtomicReference licenseFilter = new AtomicReference();
        Mockito.when((Object)mockConfigurable.register(Mockito.any(Object.class))).then(invocationOnMock -> {
            if (invocationOnMock.getArguments()[0] instanceof LicenseValidatorFilter) {
                licenseFilter.set((LicenseValidatorFilter)invocationOnMock.getArguments()[0]);
            }
            return mockConfigurable;
        });
        KafkaRestSecurityResourceExtension ext = new KafkaRestSecurityResourceExtension();
        ext.register(mockConfigurable, restConfig);
        Assert.assertNotNull(licenseFilter.get());
        TestUtils.waitUntilTrue(() -> !((LicenseValidatorFilter)licenseFilter.get()).getLicenseBackgroundFetcher().hasValidLicense(), () -> "License expected to be invalid", (long)5000L, (long)50L);
        ContainerRequestContext mockContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ((LicenseValidatorFilter)licenseFilter.get()).filter(mockContext);
        ((ContainerRequestContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).abortWith((Response)Mockito.anyObject());
    }

    @Test
    public void testFailOpen() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers);
        KafkaRestConfig restConfig = new KafkaRestConfig(props);
        Configurable mockConfigurable = (Configurable)Mockito.mock(Configurable.class);
        AtomicReference licenseFilter = new AtomicReference();
        Mockito.when((Object)mockConfigurable.register(Mockito.any(Object.class))).then(invocationOnMock -> {
            if (invocationOnMock.getArguments()[0] instanceof LicenseValidatorFilter) {
                licenseFilter.set((LicenseValidatorFilter)invocationOnMock.getArguments()[0]);
            }
            return mockConfigurable;
        });
        KafkaRestSecurityResourceExtension ext = new KafkaRestSecurityResourceExtension();
        ext.register(mockConfigurable, restConfig);
        Assert.assertNotNull(licenseFilter.get());
        TestUtils.waitUntilTrue(() -> ((LicenseValidatorFilter)licenseFilter.get()).getLicenseBackgroundFetcher().hasValidLicense(), () -> "Should get a valid license at lease once", (long)5000L, (long)50L);
        LicenseManager mockLicenseManager = (LicenseManager)Mockito.mock(LicenseManager.class);
        Mockito.when((Object)mockLicenseManager.registerOrValidateLicense(Mockito.anyString())).thenThrow(new Class[]{TimeoutException.class});
        ((LicenseValidatorFilter)licenseFilter.get()).getLicenseBackgroundFetcher().setLicenseManager(mockLicenseManager);
        ContainerRequestContext mockContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ((LicenseValidatorFilter)licenseFilter.get()).filter(mockContext);
        ((ContainerRequestContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.never())).abortWith((Response)Mockito.any(Response.class));
    }
}

