/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.filter;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.extension.KafkaRestContextProvider;
import io.confluent.kafkarest.resources.v2.ConsumersResource;
import io.confluent.kafkarest.security.config.ConfluentSecureKafkaRestConfig;
import io.confluent.kafkarest.security.context.KafkaRestContextProviderFactory;
import io.confluent.rest.RestConfigException;
import java.io.IOException;
import java.security.Principal;
import java.util.Optional;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=5000)
public final class KafkaRestContextFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(KafkaRestContextFilter.class);
    private final ConfluentSecureKafkaRestConfig secureKafkaRestConfig;
    @Context
    ResourceInfo resourceInfo;

    public KafkaRestContextFilter(ConfluentSecureKafkaRestConfig secureKafkaRestConfig) {
        this.secureKafkaRestConfig = secureKafkaRestConfig;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (requestContext.getSecurityContext() != null) {
            String resourceType = this.getResourceType(requestContext);
            Principal principal = requestContext.getSecurityContext().getUserPrincipal();
            KafkaRestContext context = this.getKafkaRestContext(resourceType, principal);
            KafkaRestContextProvider.setCurrentContext((KafkaRestContext)context);
        } else {
            log.error("Couldn't find a valid security context. Can't proceed with the request in an unauthenticated context ");
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"User cannot access the resource.").build());
        }
    }

    private KafkaRestContext getKafkaRestContext(String resourceType, Principal principal) throws IOException {
        KafkaRestContext context;
        if (principal instanceof JwtPrincipal) {
            ConfluentSecureKafkaRestConfig bearerTokenKafkaRestConfig = null;
            String jwtToken = ((JwtPrincipal)principal).getJwt();
            try {
                bearerTokenKafkaRestConfig = new ConfluentSecureKafkaRestConfig(this.secureKafkaRestConfig.getOriginalProperties(), Optional.of(jwtToken));
            }
            catch (RestConfigException e) {
                throw new IOException(e);
            }
            context = KafkaRestContextProviderFactory.getInstance().getContext(principal, bearerTokenKafkaRestConfig, resourceType, true);
        } else {
            context = KafkaRestContextProviderFactory.getInstance().getContext(principal, this.secureKafkaRestConfig, resourceType, false);
        }
        return context;
    }

    private String getResourceType(ContainerRequestContext requestContext) {
        if (ConsumersResource.class.equals((Object)this.resourceInfo.getResourceClass()) || io.confluent.kafkarest.resources.v1.ConsumersResource.class.equals((Object)this.resourceInfo.getResourceClass())) {
            return "consumer".intern();
        }
        if (requestContext.getMethod().equals("POST")) {
            return "producer".intern();
        }
        return "admin".intern();
    }
}

