/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.config;

import io.confluent.common.security.ssl.PrincipalAliasKeyManagerSpi;
import io.confluent.common.security.ssl.PrincipalAliasProvider;
import io.confluent.kafkarest.security.config.ConfluentSecureKafkaRestConfig;
import io.confluent.kafkarest.security.config.SecureConfigProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Properties;

public final class SslSecureConfigProvider
implements SecureConfigProvider {
    Properties sslClientProperties = new Properties();

    public SslSecureConfigProvider() {
        this.sslClientProperties.put("ssl.keymanager.algorithm", "PrincipalAlias");
    }

    @Override
    public Properties getProducerProperties(ConfluentSecureKafkaRestConfig secureKafkaRestConfig) {
        return this.sslClientProperties;
    }

    @Override
    public Properties getConsumerProperties(ConfluentSecureKafkaRestConfig secureKafkaRestConfig) {
        return this.sslClientProperties;
    }

    @Override
    public Properties getAdminProperties(ConfluentSecureKafkaRestConfig secureKafkaRestConfig) {
        return this.sslClientProperties;
    }

    @Override
    public boolean isPrincipalAvailable(Principal principal, ConfluentSecureKafkaRestConfig kafkaRestConfig, String resourceType) {
        try {
            KeyStore keyStore = this.getKeyStore(kafkaRestConfig, resourceType);
            HashMap userToAliasMap = new HashMap();
            PrincipalAliasKeyManagerSpi.KeyStoreParser.parse((KeyStore)keyStore, userToAliasMap);
            return userToAliasMap.containsKey(principal.getName());
        }
        catch (Exception e) {
            return false;
        }
    }

    private KeyStore getKeyStore(ConfluentSecureKafkaRestConfig kafkaRestConfig, String resourceType) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        Properties originalProperties = kafkaRestConfig.getOriginalProperties();
        String keyStoreFile = this.getPropertyWithPrefix(originalProperties, "ssl.keystore.location", resourceType + ".");
        String keyStoreType = this.getPropertyWithPrefix(originalProperties, "ssl.keystore.type", resourceType + ".");
        if (keyStoreType == null) {
            keyStoreType = kafkaRestConfig.getString("client.ssl.keystore.type");
        }
        String keyStorePassword = this.getPropertyWithPrefix(originalProperties, "ssl.keystore.password", resourceType + ".");
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(Files.newInputStream(Paths.get(keyStoreFile, new String[0]), StandardOpenOption.READ), keyStorePassword.toCharArray());
        return keyStore;
    }

    private String getPropertyWithPrefix(Properties props, String key, String prefix) {
        if (props.containsKey(prefix + key)) {
            return (String)props.get(prefix + key);
        }
        if (props.containsKey("client." + key)) {
            return (String)props.get("client." + key);
        }
        return null;
    }

    static {
        PrincipalAliasProvider.initialize();
    }
}

