/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.context;

import io.confluent.kafkarest.DefaultKafkaRestContext;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.MetadataObserver;
import io.confluent.kafkarest.extension.KafkaRestContextProvider;
import io.confluent.kafkarest.security.config.ConfluentSecureKafkaRestConfig;
import io.confluent.kafkarest.security.config.SecureConfigProviderFactory;
import io.confluent.rest.exceptions.RestNotAuthorizedException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

public class KafkaRestContextProviderFactory {
    private static final KafkaRestContextProviderFactory instance = new KafkaRestContextProviderFactory();
    private final Map<String, KafkaRestContext> userToContextMap = new HashMap<String, KafkaRestContext>();

    private KafkaRestContextProviderFactory() {
    }

    public static KafkaRestContextProviderFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KafkaRestContext getContext(Principal principal, ConfluentSecureKafkaRestConfig kafkaRestConfig, String resourceType) {
        if (this.userToContextMap.containsKey(principal.getName())) {
            return this.userToContextMap.get(principal.getName());
        }
        String string = principal.getName().intern();
        synchronized (string) {
            if (!this.userToContextMap.containsKey(principal.getName())) {
                if (!SecureConfigProviderFactory.getInstance().getSecureConfigProvider(kafkaRestConfig).isPrincipalAvailable(principal, kafkaRestConfig, resourceType)) {
                    throw new RestNotAuthorizedException("Principal not found", 401);
                }
                MetadataObserver mdObserver = KafkaRestContextProvider.getDefaultContext().getMetadataObserver();
                DefaultKafkaRestContext context = new DefaultKafkaRestContext((KafkaRestConfig)kafkaRestConfig, mdObserver, null, KafkaRestContextProvider.getDefaultContext().getConsumerManager(), KafkaRestContextProvider.getDefaultContext().getSimpleConsumerManager(), null, null);
                this.userToContextMap.put(principal.getName(), (KafkaRestContext)context);
            }
            return this.userToContextMap.get(principal.getName());
        }
    }

    public void clean() {
        for (KafkaRestContext context : this.userToContextMap.values()) {
            context.shutdown();
        }
        this.userToContextMap.clear();
    }
}

