/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.config;

import io.confluent.common.config.ConfigDef;
import io.confluent.common.security.auth.RestAuthType;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.SystemTime;
import io.confluent.kafkarest.Time;
import io.confluent.kafkarest.security.config.SecureConfigProviderFactory;
import io.confluent.rest.RestConfigException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class ConfluentSecureKafkaRestConfig
extends KafkaRestConfig {
    public static final String CONFLUENT_AUTH_PROPAGATE_CONFIG_CONFIG = "confluent.rest.auth.propagate.method";
    private static final String CONFLUENT_AUTH_PROPAGATE_CONFIG_DOC = "The mechanism used to authenticate Rest Proxy requests. When broker security is enabled, the principal from this authentication mechanism is propagated to Kafka broker requests.";
    private static final String CONFLUENT_AUTH_PROPAGATE_DEFAULT = "SSL";
    public static final String CONFLUENT_LICENSE_CONFIG = "confluent.license";
    public static final String CONFLUENT_DEFAULT_LICENSE = "";
    protected static final String CONFLUENT_LICENSE_DOC = "Confluent will issue a license key to each subscriber. The license key will be a short snippet of text that you can copy and paste. Without the license key, you can use Confluent Security Plugins for a 30-day trial period. If you are a subscriber and don't have a license key, please contact Confluent Support at support@confluent.io.";
    private static final ConfigDef confluentConfigDef = ConfluentSecureKafkaRestConfig.initConfigDef();

    public boolean isTrial() {
        return this.getString(CONFLUENT_LICENSE_CONFIG).equals(CONFLUENT_DEFAULT_LICENSE);
    }

    public String licenseString() {
        return this.getString(CONFLUENT_LICENSE_CONFIG);
    }

    public ConfluentSecureKafkaRestConfig(Properties props) throws RestConfigException {
        super(confluentConfigDef, props, (Time)new SystemTime());
    }

    public Properties getProducerProperties() {
        Properties originalProps = super.getProducerProperties();
        Properties secureProps = SecureConfigProviderFactory.getInstance().getSecureConfigProvider(this).getProducerProperties(this);
        originalProps.putAll((Map<?, ?>)secureProps);
        return originalProps;
    }

    public Properties getConsumerProperties() {
        Properties originalProps = super.getConsumerProperties();
        Properties secureProps = SecureConfigProviderFactory.getInstance().getSecureConfigProvider(this).getConsumerProperties(this);
        originalProps.putAll((Map<?, ?>)secureProps);
        return originalProps;
    }

    public Properties getAdminProperties() {
        Properties originalProps = super.getConsumerProperties();
        Properties secureProps = SecureConfigProviderFactory.getInstance().getSecureConfigProvider(this).getAdminProperties(this);
        originalProps.putAll((Map<?, ?>)secureProps);
        return originalProps;
    }

    private static ConfigDef initConfigDef() {
        return ConfluentSecureKafkaRestConfig.baseKafkaRestConfigDef().define(CONFLUENT_AUTH_PROPAGATE_CONFIG_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_AUTH_PROPAGATE_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidString.in((List)RestAuthType.NAMES), ConfigDef.Importance.LOW, CONFLUENT_AUTH_PROPAGATE_CONFIG_DOC).define(CONFLUENT_LICENSE_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_DEFAULT_LICENSE, ConfigDef.Importance.HIGH, CONFLUENT_LICENSE_DOC);
    }
}

