/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security;

import io.confluent.common.security.auth.AuthenticationCleanupFilter;
import io.confluent.common.security.auth.AuthenticationFilter;
import io.confluent.common.security.license.LicenseUtil;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.extension.RestResourceExtension;
import io.confluent.kafkarest.security.config.ConfluentSecureKafkaRestConfig;
import io.confluent.kafkarest.security.config.SecureConfigProviderFactory;
import io.confluent.kafkarest.security.context.KafkaRestContextProviderFactory;
import io.confluent.kafkarest.security.filter.KafkaRestContextCleanupFilter;
import io.confluent.kafkarest.security.filter.KafkaRestContextFilter;
import io.confluent.rest.RestConfigException;
import javax.ws.rs.core.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaRestSecurityResourceExtension
implements RestResourceExtension {
    private static final Logger log = LoggerFactory.getLogger(KafkaRestSecurityResourceExtension.class);

    public void register(Configurable<?> config, KafkaRestConfig restConfig) {
        try {
            ConfluentSecureKafkaRestConfig secureKafkaRestConfig = new ConfluentSecureKafkaRestConfig(restConfig.getOriginalProperties());
            String restAuthTypeConfig = secureKafkaRestConfig.getString("confluent.rest.auth.propagate.method");
            if (restAuthTypeConfig != null && restAuthTypeConfig.length() > 0) {
                config.register((Object)new AuthenticationFilter(restAuthTypeConfig));
                config.register((Object)new KafkaRestContextFilter(secureKafkaRestConfig));
                LicenseUtil.registerLicenseValidationFilter(config, (boolean)secureKafkaRestConfig.isTrial(), (String)secureKafkaRestConfig.getString("zookeeper.connect"), (String)secureKafkaRestConfig.licenseString());
                config.register(AuthenticationCleanupFilter.class);
                config.register(KafkaRestContextCleanupFilter.class);
            }
        }
        catch (RestConfigException e) {
            log.error("Server configuration failed: ", (Throwable)e);
            System.exit(1);
        }
    }

    public void clean() {
        KafkaRestContextProviderFactory.getInstance().clean();
        SecureConfigProviderFactory.clean();
    }
}

