/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.logging;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.confluent.common.logging.SerializableSchemaAndValue;
import io.confluent.common.logging.StructuredLoggerImpl;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class StructuredLoggerImplTest {
    private static final String LOG_MSG = "{}";
    @Mock
    private Logger innerLogger;
    @Mock
    private SchemaAndValue msg;
    @Mock
    private Supplier<SchemaAndValue> msgSupplier;
    @Captor
    private ArgumentCaptor<SerializableSchemaAndValue> captor;
    private StructuredLoggerImpl logger;
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();

    @Before
    public void setup() {
        Mockito.when((Object)this.msgSupplier.get()).thenReturn((Object)this.msg);
        this.logger = new StructuredLoggerImpl(this.innerLogger);
    }

    @Test
    public void shouldLogErrorMessage() {
        this.logger.error(this.msg);
        ((Logger)Mockito.verify((Object)this.innerLogger, (VerificationMode)Mockito.times((int)1))).error((String)ArgumentMatchers.eq((Object)LOG_MSG), this.captor.capture());
        Assert.assertThat((Object)((SerializableSchemaAndValue)this.captor.getValue()).getMessage(), (Matcher)CoreMatchers.is((Object)this.msg));
    }

    @Test
    public void shouldLogErrorMessageGivenSupplier() {
        Mockito.when((Object)this.innerLogger.isErrorEnabled()).thenReturn((Object)true);
        this.logger.error(this.msgSupplier);
        ((Supplier)Mockito.verify(this.msgSupplier, (VerificationMode)Mockito.times((int)1))).get();
        ((Logger)Mockito.verify((Object)this.innerLogger, (VerificationMode)Mockito.times((int)1))).error((String)ArgumentMatchers.eq((Object)LOG_MSG), this.captor.capture());
        Assert.assertThat((Object)((SerializableSchemaAndValue)this.captor.getValue()).getMessage(), (Matcher)CoreMatchers.is((Object)this.msg));
    }

    @Test
    public void shouldNotGetMessageIfLoggerDisabledForError() {
        Mockito.when((Object)this.innerLogger.isErrorEnabled()).thenReturn((Object)false);
        this.logger.error(this.msgSupplier);
        ((Logger)Mockito.verify((Object)this.innerLogger)).isErrorEnabled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.innerLogger, this.msgSupplier});
    }

    @Test
    public void shouldLogInfoMessage() {
        this.logger.info(this.msg);
        ((Logger)Mockito.verify((Object)this.innerLogger, (VerificationMode)Mockito.times((int)1))).info((String)ArgumentMatchers.eq((Object)LOG_MSG), this.captor.capture());
        Assert.assertThat((Object)((SerializableSchemaAndValue)this.captor.getValue()).getMessage(), (Matcher)CoreMatchers.is((Object)this.msg));
    }

    @Test
    public void shouldLogInfoMessageGivenSupplier() {
        Mockito.when((Object)this.innerLogger.isInfoEnabled()).thenReturn((Object)true);
        this.logger.info(this.msgSupplier);
        ((Supplier)Mockito.verify(this.msgSupplier, (VerificationMode)Mockito.times((int)1))).get();
        ((Logger)Mockito.verify((Object)this.innerLogger, (VerificationMode)Mockito.times((int)1))).info((String)ArgumentMatchers.eq((Object)LOG_MSG), this.captor.capture());
        Assert.assertThat((Object)((SerializableSchemaAndValue)this.captor.getValue()).getMessage(), (Matcher)CoreMatchers.is((Object)this.msg));
    }

    @Test
    public void shouldNotGetMessageIfLoggerDisabledForInfo() {
        Mockito.when((Object)this.innerLogger.isInfoEnabled()).thenReturn((Object)false);
        this.logger.info(this.msgSupplier);
        ((Logger)Mockito.verify((Object)this.innerLogger)).isInfoEnabled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.innerLogger, this.msgSupplier});
    }

    @Test
    public void shouldLogDebugMessage() {
        this.logger.debug(this.msg);
        ((Logger)Mockito.verify((Object)this.innerLogger, (VerificationMode)Mockito.times((int)1))).debug((String)ArgumentMatchers.eq((Object)LOG_MSG), this.captor.capture());
        Assert.assertThat((Object)((SerializableSchemaAndValue)this.captor.getValue()).getMessage(), (Matcher)CoreMatchers.is((Object)this.msg));
    }

    @Test
    public void shouldLogDebugMessageGivenSupplier() {
        Mockito.when((Object)this.innerLogger.isDebugEnabled()).thenReturn((Object)true);
        this.logger.debug(this.msgSupplier);
        ((Supplier)Mockito.verify(this.msgSupplier, (VerificationMode)Mockito.times((int)1))).get();
        ((Logger)Mockito.verify((Object)this.innerLogger, (VerificationMode)Mockito.times((int)1))).debug((String)ArgumentMatchers.eq((Object)LOG_MSG), this.captor.capture());
        Assert.assertThat((Object)((SerializableSchemaAndValue)this.captor.getValue()).getMessage(), (Matcher)CoreMatchers.is((Object)this.msg));
    }

    @Test
    public void shouldNotGetMessageIfLoggerDisabledForDebug() {
        Mockito.when((Object)this.innerLogger.isDebugEnabled()).thenReturn((Object)false);
        this.logger.debug(this.msgSupplier);
        ((Logger)Mockito.verify((Object)this.innerLogger)).isDebugEnabled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.innerLogger, this.msgSupplier});
    }

    @Test
    public void shouldSerializeMessageToJsonString() throws IOException {
        Schema msgSchema = SchemaBuilder.struct().field("field1", Schema.STRING_SCHEMA).field("field2", Schema.INT32_SCHEMA).build();
        Struct msgStruct = new Struct(msgSchema);
        msgStruct.put("field1", (Object)"foobar");
        msgStruct.put("field2", (Object)123);
        SchemaAndValue schemaAndValue = new SchemaAndValue(msgSchema, (Object)msgStruct);
        this.logger.info(schemaAndValue);
        ((Logger)Mockito.verify((Object)this.innerLogger)).info((String)ArgumentMatchers.any(), this.captor.capture());
        String asString = ((SerializableSchemaAndValue)this.captor.getValue()).toString();
        Object deserialized = new ObjectMapper().readValue(asString, Object.class);
        Assert.assertThat((Object)deserialized, (Matcher)CoreMatchers.instanceOf(Map.class));
        Assert.assertThat((Object)deserialized, (Matcher)CoreMatchers.equalTo((Object)ImmutableMap.of((Object)"field1", (Object)"foobar", (Object)"field2", (Object)123)));
    }
}

