/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.logging;

import io.confluent.common.logging.SerializableSchemaAndValue;
import io.confluent.common.logging.StructuredLogger;
import io.confluent.common.logging.StructuredLoggerFactory;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class StructuredLoggerFactoryTest {
    private static final String PREFIX = "prefix";
    @Mock
    private Function<String, Logger> innerFactory;
    @Mock
    private Logger innerLogger;
    private StructuredLoggerFactory loggerFactory;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();

    @Before
    public void setup() {
        this.loggerFactory = new StructuredLoggerFactory(PREFIX, this.innerFactory);
    }

    @Test
    public void shouldCreateLoggerCorrectly() {
        Mockito.when((Object)this.innerFactory.apply("prefix.foo")).thenReturn((Object)this.innerLogger);
        StructuredLogger logger = this.loggerFactory.getLogger("foo");
        logger.info((SchemaAndValue)Mockito.mock(SchemaAndValue.class));
        ((Function)Mockito.verify(this.innerFactory, (VerificationMode)Mockito.times((int)1))).apply("prefix.foo");
        ((Logger)Mockito.verify((Object)this.innerLogger)).info((String)ArgumentMatchers.any(String.class), ArgumentMatchers.any(SerializableSchemaAndValue.class));
    }

    @Test
    public void shouldAddPrefixToClassName() {
        Mockito.when((Object)this.innerFactory.apply("prefix.java.util.Map")).thenReturn((Object)this.innerLogger);
        this.loggerFactory.getLogger(Map.class);
        ((Function)Mockito.verify(this.innerFactory, (VerificationMode)Mockito.times((int)1))).apply("prefix.java.util.Map");
    }
}

