/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.logging;

import io.confluent.common.logging.LogRecordStructBuilder;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LogRecordStructBuilderTest {
    private final LogRecordStructBuilder builder = new LogRecordStructBuilder();

    @Test
    public void shouldBuildStructCorrectly() {
        Schema msgSchema = SchemaBuilder.struct().field("field1", Schema.STRING_SCHEMA).field("field2", Schema.INT32_SCHEMA).build();
        Struct msg = new Struct(msgSchema).put("field1", (Object)"bizbaz").put("field2", (Object)1129);
        Struct logRecord = this.builder.withLevel("INFO").withLoggerName("foo.bar").withTimeMs(123L).withMessageSchemaAndValue(new SchemaAndValue(msgSchema, (Object)msg)).build();
        Assert.assertThat(logRecord.schema().fields().stream().map(Field::name).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"logger", "level", "time", "message"}));
        Assert.assertThat((Object)logRecord.get("level"), (Matcher)Matchers.equalTo((Object)"INFO"));
        Assert.assertThat((Object)logRecord.get("logger"), (Matcher)Matchers.equalTo((Object)"foo.bar"));
        Assert.assertThat((Object)logRecord.get("time"), (Matcher)Matchers.equalTo((Object)123L));
        Assert.assertThat((Object)logRecord.get("message"), (Matcher)Matchers.equalTo((Object)msg));
    }
}

