/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.logging;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.confluent.common.logging.LogRecordStringBuilder;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class LogRecordStringBuilderTest {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final LogRecordStringBuilder builder = new LogRecordStringBuilder();

    @Test
    public void shouldSerializeRecordCorrectly() throws IOException {
        String record = (String)this.builder.withLevel("INFO").withLoggerName("foo.bar").withTimeMs(123L).withMessageJson("{\"field1\": 456, \"field2\": \"bizbaz\"}").build();
        Object deserialized = this.objectMapper.readValue(record, Object.class);
        Assert.assertThat((Object)deserialized, (Matcher)CoreMatchers.instanceOf(Map.class));
        Map asMap = (Map)deserialized;
        ImmutableMap expected = ImmutableMap.of((Object)"level", (Object)"INFO", (Object)"logger", (Object)"foo.bar", (Object)"time", (Object)123, (Object)"message", (Object)ImmutableMap.of((Object)"field1", (Object)456, (Object)"field2", (Object)"bizbaz"));
        Assert.assertThat((Object)asMap, (Matcher)CoreMatchers.equalTo((Object)expected));
    }
}

