/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.http.server.integration.fixtures;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.http.server.integration.fixtures.FooBarResource;
import io.confluent.http.server.integration.fixtures.ReconfigurationTrackerResource;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.validation.JacksonMessageBodyProvider;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.core.Configurable;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;

public final class FooBarApplication
extends Application<RestConfig>
implements Reconfigurable {
    private static final AtomicBoolean SHUTDOWN_CALLED = new AtomicBoolean(false);
    private ReconfigurationTrackerResource reconfigurableTracker;

    public FooBarApplication() {
        super(new RestConfig(RestConfig.baseConfigDef()), "/");
        SHUTDOWN_CALLED.set(false);
    }

    public void setupResources(Configurable<?> context, RestConfig restConfig) {
        ObjectMapper jsonMapper = new ObjectMapper();
        JacksonMessageBodyProvider jsonProvider = new JacksonMessageBodyProvider(jsonMapper);
        this.reconfigurableTracker = new ReconfigurationTrackerResource();
        context.register((Object)jsonProvider);
        context.register((Object)new FooBarResource());
        context.register((Object)this.reconfigurableTracker);
    }

    public void onShutdown() {
        SHUTDOWN_CALLED.set(true);
    }

    public static boolean wasShutdown() {
        return SHUTDOWN_CALLED.get();
    }

    public Set<String> reconfigurableConfigs() {
        this.reconfigurableTracker.gotConfigs();
        return Collections.singleton("config-1");
    }

    public void validateReconfiguration(Map<String, ?> map) throws ConfigException {
        this.reconfigurableTracker.validated();
    }

    public void reconfigure(Map<String, ?> map) {
        this.reconfigurableTracker.reconfigured();
    }

    public void configure(Map<String, ?> map) {
    }
}

