/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.TrafficNetworkIdValidationMode;
import java.util.Arrays;
import java.util.Optional;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TrafficNetworkIdValidationModeTest {
    @Test
    public void fromStringTest() {
        Assertions.assertEquals((Object)TrafficNetworkIdValidationMode.NONE, (Object)TrafficNetworkIdValidationMode.fromString(null), (String)"Should return none if input is null");
        Assertions.assertEquals((Object)TrafficNetworkIdValidationMode.NONE, (Object)TrafficNetworkIdValidationMode.fromString((String)"foo"), (String)"Should return none if input is not recognized");
        Assertions.assertEquals((Object)TrafficNetworkIdValidationMode.NONE, (Object)TrafficNetworkIdValidationMode.fromString((String)TrafficNetworkIdValidationMode.NONE.name()), (String)"Should parse none successfully");
        Assertions.assertEquals((Object)TrafficNetworkIdValidationMode.STRICT, (Object)TrafficNetworkIdValidationMode.fromString((String)TrafficNetworkIdValidationMode.STRICT.name()), (String)"Should parse strict successfully");
        Assertions.assertEquals((Object)TrafficNetworkIdValidationMode.STRICT, (Object)TrafficNetworkIdValidationMode.fromString((String)"strict"), (String)"Should parse strict successfully");
    }

    @Test
    public void testNoneAllowsEverything() {
        Assertions.assertTrue((boolean)TrafficNetworkIdValidationMode.NONE.trafficAllowed(Optional.empty(), TrafficNetworkIdRoutes.EMPTY));
        Assertions.assertTrue((boolean)TrafficNetworkIdValidationMode.NONE.trafficAllowed(Optional.of("foo"), TrafficNetworkIdRoutes.EMPTY));
        Assertions.assertTrue((boolean)TrafficNetworkIdValidationMode.NONE.trafficAllowed(Optional.of("foo"), new TrafficNetworkIdRoutes(Arrays.asList("bar"))));
    }

    @Test
    public void testStrictAllows() {
        Assertions.assertFalse((boolean)TrafficNetworkIdValidationMode.STRICT.trafficAllowed(Optional.empty(), TrafficNetworkIdRoutes.EMPTY));
        Assertions.assertFalse((boolean)TrafficNetworkIdValidationMode.STRICT.trafficAllowed(Optional.of("foo"), TrafficNetworkIdRoutes.EMPTY));
        TrafficNetworkIdRoutes routes = new TrafficNetworkIdRoutes(Arrays.asList("nr1", "nr2"));
        Assertions.assertFalse((boolean)TrafficNetworkIdValidationMode.STRICT.trafficAllowed(Optional.empty(), routes));
        Assertions.assertFalse((boolean)TrafficNetworkIdValidationMode.STRICT.trafficAllowed(Optional.of("foo"), routes));
        Assertions.assertTrue((boolean)TrafficNetworkIdValidationMode.STRICT.trafficAllowed(Optional.of("nr1"), routes));
        Assertions.assertTrue((boolean)TrafficNetworkIdValidationMode.STRICT.trafficAllowed(Optional.of("nr2"), routes));
    }
}

