/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule;
import io.confluent.kafka.server.plugins.auth.TopicBasedPlainSaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.TrafficNetworkIdValidationMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutes;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutesStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TopicBasedPlainSaslAuthenticatorTest {
    @Test
    public void testVerifyValidNetworkId() throws Exception {
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), TrafficNetworkIdValidationMode.STRICT);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("ne1")));
        authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), CCloudTrafficType.PL_PUBLIC_IP_NLB);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("ne1")));
        authenticator = this.createAuthenticator(new TrafficNetworkIdRoutes(Arrays.asList("ne1", "ne2")), TrafficNetworkIdValidationMode.NONE, CCloudTrafficType.PL_PUBLIC_IP_NLB);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("ne1")));
    }

    @Test
    public void testVerifyInvalidNetworkId() throws Exception {
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), TrafficNetworkIdValidationMode.STRICT);
        this.assertInvalidNetworkFailsAuth(authenticator);
        authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), CCloudTrafficType.PL_PUBLIC_IP_NLB);
        this.assertInvalidNetworkFailsAuth(authenticator);
        authenticator = this.createAuthenticator(new TrafficNetworkIdRoutes(Arrays.asList("ne1", "ne2")), TrafficNetworkIdValidationMode.NONE, CCloudTrafficType.PL_PUBLIC_IP_NLB);
        this.assertInvalidNetworkFailsAuth(authenticator);
    }

    private void assertInvalidNetworkFailsAuth(TopicBasedPlainSaslAuthenticator authenticator) {
        SaslAuthenticationException exception = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("neInvalid")));
        Assertions.assertTrue((boolean)exception.errorInfo().errorMessage().contains("isn't allowed to communicate to the cluster ID"));
    }

    @Test
    public void testRoutesNotYetLoaded() throws Exception {
        TrafficNetworkIdRoutes routes = null;
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(routes, TrafficNetworkIdValidationMode.STRICT);
        SaslAuthenticationException exception = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("ne1")));
        Assertions.assertTrue((boolean)exception.errorInfo().errorMessage().contains("validation failed due to an internal error"));
    }

    @Test
    public void testRoutesNotYetLoadedNoneMode() throws Exception {
        TrafficNetworkIdRoutes routes = null;
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(routes, TrafficNetworkIdValidationMode.NONE);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("ne1")));
    }

    @Test
    public void testVerifyNoneMode() throws Exception {
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), TrafficNetworkIdValidationMode.NONE);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("neInvalid")));
        authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), (TrafficNetworkIdValidationMode)null);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("neInvalid")));
        authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), CCloudTrafficType.UNKNOWN);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("neInvalid")));
        authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), CCloudTrafficType.PL_PRIVATE_LINK_NLB);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("neInvalid")));
    }

    @Test
    public void testVerifyListenerStrictModeOverridesTlvNoneMode() throws Exception {
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(new TrafficNetworkIdRoutes(Arrays.asList("ne1", "ne2")), TrafficNetworkIdValidationMode.STRICT, CCloudTrafficType.UNKNOWN);
        this.assertInvalidNetworkFailsAuth(authenticator);
    }

    private MultiTenantSaslConfigEntry getUserInfo() {
        return new MultiTenantSaslConfigEntry("PLAIN", "foobar", "none", "23", "lkc-bkey", false, "u-23");
    }

    private TopicBasedPlainSaslAuthenticator createAuthenticator(List<String> routesList, TrafficNetworkIdValidationMode networkIdValidationMode) throws Exception {
        TrafficNetworkIdRoutes routes = new TrafficNetworkIdRoutes(routesList);
        return this.createAuthenticator(routes, networkIdValidationMode, null);
    }

    private TopicBasedPlainSaslAuthenticator createAuthenticator(List<String> routesList, CCloudTrafficType trafficTypeTlv) throws Exception {
        TrafficNetworkIdRoutes routes = new TrafficNetworkIdRoutes(routesList);
        return this.createAuthenticator(routes, null, trafficTypeTlv);
    }

    private TopicBasedPlainSaslAuthenticator createAuthenticator(TrafficNetworkIdRoutes routes, TrafficNetworkIdValidationMode networkIdValidationMode) throws Exception {
        return this.createAuthenticator(routes, networkIdValidationMode, null);
    }

    private TopicBasedPlainSaslAuthenticator createAuthenticator(TrafficNetworkIdRoutes routes, TrafficNetworkIdValidationMode networkIdValidationMode, CCloudTrafficType trafficTypeTlv) throws Exception {
        TrafficNetworkIdRoutesStore routesLoader = (TrafficNetworkIdRoutesStore)Mockito.mock(TrafficNetworkIdRoutesStore.class);
        Mockito.when((Object)routesLoader.load()).thenReturn((Object)routes);
        TopicBasedPlainSaslAuthenticator authenticator = new TopicBasedPlainSaslAuthenticator(null, routesLoader, trafficTypeTlv);
        HashMap<String, String> options = new HashMap<String, String>();
        if (networkIdValidationMode != null) {
            options.put("traffic_network_id_validation_mode", networkIdValidationMode.name());
        }
        AppConfigurationEntry entry = new AppConfigurationEntry(TopicBasedLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        List<AppConfigurationEntry> jaasEntries = Collections.singletonList(entry);
        authenticator.initialize(jaasEntries);
        if (trafficTypeTlv != null && trafficTypeTlv.shouldValidateTraffic()) {
            Assertions.assertEquals((Object)TrafficNetworkIdValidationMode.STRICT, (Object)authenticator.networkIdValidationMode);
        } else if (networkIdValidationMode != null) {
            Assertions.assertEquals((Object)authenticator.networkIdValidationMode, (Object)networkIdValidationMode);
        } else {
            Assertions.assertEquals((Object)authenticator.networkIdValidationMode, (Object)TrafficNetworkIdValidationMode.NONE);
        }
        return authenticator;
    }
}

