/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authorizer.acl;

import io.confluent.kafka.security.authorizer.acl.AclMapper;
import io.confluent.kafka.security.authorizer.acl.StandardAclProvider;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import java.util.Collections;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerData;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class StandardAclProviderTest {
    StandardAclProviderTest() {
    }

    @Test
    public void testFindRuleAllowAcl() {
        StandardAuthorizer authorizer = (StandardAuthorizer)Mockito.mock(StandardAuthorizer.class);
        StandardAclProvider provider = new StandardAclProvider(authorizer);
        KafkaPrincipal principal = new KafkaPrincipal("User", "grover");
        String host = "127.0.0.1";
        String topic = "foo";
        io.confluent.security.authorizer.Action action = new io.confluent.security.authorizer.Action(Scope.ROOT_SCOPE, AclMapper.resourceType((ResourceType)ResourceType.TOPIC), topic, AclMapper.operation((AclOperation)AclOperation.READ));
        Action standardAction = new Action(AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL), 1, true, true);
        StandardAuthorizerData.MatchingAclRule matchingRule = new StandardAuthorizerData.MatchingAclRule(new StandardAcl(ResourceType.TOPIC, topic, PatternType.LITERAL, AccessRule.WILDCARD_USER_PRINCIPAL.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW), AuthorizationResult.ALLOWED);
        Mockito.when((Object)authorizer.findRule(Utils.mkSet((Object[])new KafkaPrincipal[]{principal, AccessRule.WILDCARD_USER_PRINCIPAL}), host, standardAction)).thenReturn((Object)matchingRule);
        AuthorizeRule rule = provider.findRule(principal, Collections.emptySet(), host, action);
        Assertions.assertFalse((boolean)rule.deny());
        Assertions.assertTrue((boolean)rule.allowRule().isPresent());
    }

    @Test
    public void testFindRuleDenyAcl() {
        StandardAuthorizer authorizer = (StandardAuthorizer)Mockito.mock(StandardAuthorizer.class);
        StandardAclProvider provider = new StandardAclProvider(authorizer);
        KafkaPrincipal principal = new KafkaPrincipal("User", "grover");
        String host = "127.0.0.1";
        String topic = "foo";
        io.confluent.security.authorizer.Action action = new io.confluent.security.authorizer.Action(Scope.ROOT_SCOPE, AclMapper.resourceType((ResourceType)ResourceType.TOPIC), topic, AclMapper.operation((AclOperation)AclOperation.READ));
        Action standardAction = new Action(AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL), 1, true, true);
        StandardAuthorizerData.MatchingAclRule matchingRule = new StandardAuthorizerData.MatchingAclRule(new StandardAcl(ResourceType.TOPIC, topic, PatternType.LITERAL, AccessRule.WILDCARD_USER_PRINCIPAL.toString(), "*", AclOperation.READ, AclPermissionType.DENY), AuthorizationResult.DENIED);
        Mockito.when((Object)authorizer.findRule(Utils.mkSet((Object[])new KafkaPrincipal[]{principal, AccessRule.WILDCARD_USER_PRINCIPAL}), host, standardAction)).thenReturn((Object)matchingRule);
        AuthorizeRule rule = provider.findRule(principal, Collections.emptySet(), host, action);
        Assertions.assertTrue((boolean)rule.deny());
    }

    @Test
    public void testFindRuleNoAclRule() {
        StandardAuthorizer authorizer = (StandardAuthorizer)Mockito.mock(StandardAuthorizer.class);
        StandardAclProvider provider = new StandardAclProvider(authorizer);
        KafkaPrincipal principal = new KafkaPrincipal("User", "grover");
        String host = "127.0.0.1";
        String topic = "foo";
        io.confluent.security.authorizer.Action action = new io.confluent.security.authorizer.Action(Scope.ROOT_SCOPE, AclMapper.resourceType((ResourceType)ResourceType.TOPIC), topic, AclMapper.operation((AclOperation)AclOperation.READ));
        Action standardAction = new Action(AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL), 1, true, true);
        StandardAuthorizerData.DefaultRule noAclRule = new StandardAuthorizerData.DefaultRule(AuthorizationResult.ALLOWED);
        Mockito.when((Object)authorizer.findRule(Utils.mkSet((Object[])new KafkaPrincipal[]{principal, AccessRule.WILDCARD_USER_PRINCIPAL}), host, standardAction)).thenReturn((Object)noAclRule);
        AuthorizeRule rule = provider.findRule(principal, Collections.emptySet(), host, action);
        Assertions.assertFalse((boolean)rule.deny());
        Assertions.assertFalse((boolean)rule.allowRule().isPresent());
        Assertions.assertTrue((boolean)rule.noResourceAcls());
    }

    @Test
    public void testFindRuleDefaultDeny() {
        StandardAuthorizer authorizer = (StandardAuthorizer)Mockito.mock(StandardAuthorizer.class);
        StandardAclProvider provider = new StandardAclProvider(authorizer);
        KafkaPrincipal principal = new KafkaPrincipal("User", "grover");
        String host = "127.0.0.1";
        String topic = "foo";
        io.confluent.security.authorizer.Action action = new io.confluent.security.authorizer.Action(Scope.ROOT_SCOPE, AclMapper.resourceType((ResourceType)ResourceType.TOPIC), topic, AclMapper.operation((AclOperation)AclOperation.READ));
        Action standardAction = new Action(AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL), 1, true, true);
        StandardAuthorizerData.DefaultRule defaultDeny = new StandardAuthorizerData.DefaultRule(AuthorizationResult.DENIED);
        Mockito.when((Object)authorizer.findRule(Utils.mkSet((Object[])new KafkaPrincipal[]{principal, AccessRule.WILDCARD_USER_PRINCIPAL}), host, standardAction)).thenReturn((Object)defaultDeny);
        AuthorizeRule rule = provider.findRule(principal, Collections.emptySet(), host, action);
        Assertions.assertFalse((boolean)rule.deny());
        Assertions.assertFalse((boolean)rule.allowRule().isPresent());
        Assertions.assertFalse((boolean)rule.noResourceAcls());
    }
}

