/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authorizer;

import io.confluent.kafka.security.authorizer.ConfluentServerAuthorizer;
import io.confluent.kafka.test.utils.SecurityTestUtils;
import java.util.Collections;
import java.util.Properties;
import kafka.api.SaslEndToEndAuthorizationTest;
import kafka.server.KafkaConfig$;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestInfoUtils;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.collection.JavaConverters;
import scala.collection.immutable.List;

public class AclEndToEndAuthorizationTest
extends SaslEndToEndAuthorizationTest {
    public String unimplementedquorum() {
        return "kraft";
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (!TestInfoUtils.isKRaft((TestInfo)testInfo)) {
            Properties serverConfig = this.serverConfig();
            serverConfig.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), ConfluentServerAuthorizer.class.getName());
            super.setUp(testInfo);
        }
    }

    public String kafkaClientSaslMechanism() {
        return "SCRAM-SHA-256";
    }

    public List<String> kafkaServerSaslMechanisms() {
        return JavaConverters.asScalaBuffer(Collections.singletonList("SCRAM-SHA-256")).toList();
    }

    public KafkaPrincipal clientPrincipal() {
        return new KafkaPrincipal("User", JaasTestUtils.KafkaScramUser());
    }

    public KafkaPrincipal kafkaPrincipal() {
        return new KafkaPrincipal("User", JaasTestUtils.KafkaScramAdmin());
    }

    public void configureSecurityBeforeServersStart(TestInfo testInfo) {
        super.configureSecurityBeforeServersStart(testInfo);
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), this.kafkaPrincipal().getName(), JaasTestUtils.KafkaScramAdminPassword());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils.KafkaScramUser(), JaasTestUtils.KafkaScramPassword());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils.KafkaScramUser2(), JaasTestUtils.KafkaScramPassword2());
        SecurityTestUtils.addLicenseTopicAcl(this.zkConnect(), this.kafkaPrincipal());
    }
}

