/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import io.confluent.kafka.multitenant.metrics.TenantMetricsTestUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TenantConnectionMetricsTest {
    private final String tenantName = "tenant";
    private TenantMetricsTestUtils utils;
    private Metrics metrics;
    private MultiTenantPrincipal principal;
    private InetAddress clientAddress;
    private MetricsBuilderContext tenantContext;
    private MetricsBuilderContext ipContext;

    @BeforeEach
    public void setUp() throws UnknownHostException {
        this.metrics = new Metrics();
        this.principal = new MultiTenantPrincipal("user", new TenantMetadata("tenant", "cluster-1"));
        this.clientAddress = InetAddress.getByName("127.0.0.1");
        this.utils = new TenantMetricsTestUtils(this.metrics);
        this.tenantContext = new TenantMetrics.TenantMetricsContext(this.principal);
        this.ipContext = new TenantMetrics.TenantIpMetricsContext(this.principal, this.clientAddress);
    }

    @Test
    public void testTenantUserMetricsSeparateFromTenantIpMetrics() throws UnknownHostException {
        TenantMetrics firstConnection = new TenantMetrics();
        firstConnection.recordAuthenticatedConnection(this.metrics, this.principal, this.clientAddress);
        this.utils.verifyActiveTenantConnectionsMetrics(Collections.singletonMap(this.tenantContext, 1.0));
        this.utils.verifyActiveTenantIpConnectionsMetrics(Collections.singletonMap(this.ipContext, 1.0));
        InetAddress secondClientAddress = InetAddress.getByName("127.0.0.2");
        TenantMetrics secondConnection = new TenantMetrics();
        secondConnection.recordAuthenticatedConnection(this.metrics, this.principal, secondClientAddress);
        this.utils.verifyActiveTenantConnectionsMetrics(Collections.singletonMap(this.tenantContext, 2.0));
        this.utils.verifyActiveTenantIpConnectionsMetrics(Collections.singletonMap(this.ipContext, 1.0));
        MultiTenantPrincipal secondUser = new MultiTenantPrincipal("user2", new TenantMetadata("tenant", "cluster-1"));
        TenantMetrics thirdConnection = new TenantMetrics();
        thirdConnection.recordAuthenticatedConnection(this.metrics, secondUser, this.clientAddress);
        this.utils.verifyActiveTenantConnectionsMetrics(Collections.singletonMap(this.tenantContext, 2.0));
        this.utils.verifyActiveTenantIpConnectionsMetrics(Collections.singletonMap(this.ipContext, 2.0));
        thirdConnection.recordAuthenticatedDisconnection();
        this.utils.verifyActiveTenantConnectionsMetrics(Collections.singletonMap(this.tenantContext, 2.0));
        this.utils.verifyActiveTenantIpConnectionsMetrics(Collections.singletonMap(this.ipContext, 1.0));
        secondConnection.recordAuthenticatedDisconnection();
        this.utils.verifyActiveTenantConnectionsMetrics(Collections.singletonMap(this.tenantContext, 1.0));
        this.utils.verifyActiveTenantIpConnectionsMetrics(Collections.singletonMap(this.ipContext, 1.0));
    }
}

