/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.TopicBasedPhysicalClusterMetadata;
import io.confluent.kafka.multitenant.assignor.TenantPartitionAssignorBuilder;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.server.plugins.policy.AlterConfigPolicy;
import io.confluent.kafka.server.plugins.policy.CreateTopicPolicy;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.KafkaConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class TopicBasedPhysicalClusterMetadataMissingTopicIntegrationTest {
    private final String topicName = "_confluent-logical_clusters";
    private final int brokerCount = 3;
    private Properties controllerProps = new Properties();
    private Properties allProps = new Properties();
    private IntegrationTestHarness testHarness;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        Map<String, Object> propsMap = Stream.of({KafkaConfig.ListenersProp(), "INTERNAL://localhost:0, EXTERNAL://localhost:0"}, {"advertised.listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0"}, {KafkaConfig.ListenerSecurityProtocolMapProp(), "INTERNAL:PLAINTEXT, EXTERNAL:SASL_PLAINTEXT"}, {"inter.broker.listener.name", "INTERNAL"}, {"confluent.multitenant.listener.names", "EXTERNAL"}).collect(Collectors.toMap(prop -> prop[0].toString(), prop -> prop[1]));
        this.allProps.putAll(propsMap);
        this.allProps.putAll(this.nodeProps());
        this.controllerProps.putAll(this.nodeProps());
        this.testHarness = new IntegrationTestHarness(testInfo, 3);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
    }

    public Map<String, Object> nodeProps() {
        return Stream.of({KafkaConfig.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName()}, {"confluent.topic.replica.assignor.builder.class", TenantPartitionAssignorBuilder.class.getName()}, {KafkaConfig.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class.getName()}, {AclAuthorizer.AllowEveryoneIfNoAclIsFoundProp(), "true"}, {KafkaConfig.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class.getName()}, {"confluent.plugins.topic.policy.replication.factor", "1"}, {KafkaConfig.AutoCreateTopicsEnableProp(), "false"}, {"confluent.cdc.lkc.metadata.topic", "_confluent-logical_clusters"}, {"confluent.cdc.api.keys.topic.load.timeout.ms", 15000L}, {"multitenant.metadata.class", TopicBasedPhysicalClusterMetadata.class.getName()}, {"multitenant.tenant.delete.delay", TimeUnit.SECONDS.toMillis(1L)}, {"multitenant.tenant.delete.check.ms", TimeUnit.SECONDS.toMillis(1L)}).collect(Collectors.toMap(prop -> prop[0].toString(), prop -> prop[1]));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFailToReadTopic(String quorum) throws Exception {
        Assertions.assertThrows(RuntimeException.class, () -> this.testHarness.start(this.allProps, this.controllerProps, true, Optional.empty(), cluster -> {}));
    }
}

