/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.tools.MultiTenantInfoCommand;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
class MultiTenantInfoCommandTest
extends AbstractMultiTenantKafkaIntegrationTest {
    private Integer exitCode;
    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    MultiTenantInfoCommandTest() {
    }

    @BeforeEach
    void setupExitProcedure() {
        Exit.setExitProcedure((code, message) -> {
            if (this.exitCode == null) {
                this.exitCode = code;
            }
        });
    }

    @Override
    @BeforeEach
    public void setUpTempDir(TestInfo testInfo) {
        super.setUpTempDir(testInfo);
    }

    @AfterEach
    public void reset() {
        this.exitCode = null;
        this.outputStream.reset();
        System.setOut(System.out);
    }

    @Override
    protected void createPhysicalAndLogicalClusters(Properties brokerProperties) {
        this.setUp(1, Collections.emptyList());
        Properties props = new Properties(super.nodeProps());
        props.putAll((Map<?, ?>)brokerProperties);
        super.createPhysicalAndLogicalClusters(props);
        this.awaitMetadataPropagation();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testDescribeNetwork(String quorum) throws Throwable {
        this.createPhysicalAndLogicalClusters(this.networkProperties());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "describe-network", "--listener-name", "EXTERNAL"};
        StringBuilder sb = new StringBuilder();
        sb.append("Tenant IpAddress List: 1\n");
        sb.append("Tenant     \tClientIpAddress\t\n");
        sb.append("lkc-tenant1\t127.0.0.1      \t\n");
        sb.append("\nClientApiKey IpAddress List: 0\n");
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(11), "testtopic", "group1", 0);
        this.executeCmd(cmdArgs);
        this.verifyExitCodeAndMessage(0, sb.toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testDescribeNetworkWithTenant(String quorum) throws Throwable {
        this.createPhysicalAndLogicalClusters(this.networkProperties());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "describe-network", "--tenant-id", "lkc-tenant2"};
        StringBuilder sb = new StringBuilder();
        sb.append("Tenant IpAddress List: 1\n");
        sb.append("Tenant     \tClientIpAddress\t\n");
        sb.append("lkc-tenant2\t127.0.0.1      \t\n");
        sb.append("\nClientApiKey IpAddress List: 0\n");
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "testtopic", "group1", 0);
        this.testHarness.produceConsume(this.logicalCluster2.user(21), this.logicalCluster2.user(22), "testtopic", "group1", 0);
        this.executeCmd(cmdArgs);
        this.verifyExitCodeAndMessage(0, sb.toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testDescribeNetworkWithIpAddressList(String quorum) throws Throwable {
        this.createPhysicalAndLogicalClusters(this.networkProperties());
        String[] cmdArgs = new String[]{"--bootstrap-server", this.physicalCluster.bootstrapServers("INTERNAL"), "describe-network", "--ip-addresses", "127.0.0.1"};
        StringBuilder sb = new StringBuilder();
        sb.append("Tenant IpAddress List: 1\n");
        sb.append("Tenant     \tClientIpAddress\t\n");
        sb.append("lkc-tenant1\t127.0.0.1      \t\n");
        sb.append("\nClientApiKey IpAddress List: 0\n");
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "testtopic", "group1", 0);
        this.executeCmd(cmdArgs);
        this.verifyExitCodeAndMessage(0, sb.toString());
    }

    private Properties networkProperties() {
        Properties props = this.nodeProps();
        props.put("confluent.track.tenant.id.per.ip", (Object)true);
        props.put("confluent.track.api.key.per.ip", (Object)true);
        return props;
    }

    private void verifyExitCodeAndMessage(int expectedExitCode, String expectedMessage) {
        Assertions.assertEquals((int)expectedExitCode, (Integer)this.exitCode);
        Assertions.assertEquals((Object)expectedMessage, (Object)this.outputStream.toString());
    }

    private void executeCmd(String[] cmdArgs) throws Exception {
        System.setOut(new PrintStream(this.outputStream));
        MultiTenantInfoCommand.main((String[])cmdArgs);
    }
}

