/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.authorizer;

import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.server.plugins.auth.DefaultUserMetaDataStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class MultiTenantAuthorizerUnitTest {
    private static String prefixPrincipal = "TenantUser:lck-abc_";
    private static DefaultUserMetaDataStore userMetaDataStore;
    private static Map<String, String> userResourceIdToUserId;
    private static Map<String, String> userIdToUserResourceId;
    private static List<String> userAndResourceIds;
    private final String userResourceId2 = "u-2";
    private final String userResourceId3 = "u-3";
    private final String userId2 = "2";
    private final String userId3 = "3";

    @BeforeEach
    void setUp() {
        userResourceIdToUserId = new ConcurrentHashMap<String, String>();
        userIdToUserResourceId = new ConcurrentHashMap<String, String>();
        userAndResourceIds = Collections.unmodifiableList(Arrays.asList("2", "3", "u-2", "u-3"));
        userResourceIdToUserId.put("u-2", "2");
        userIdToUserResourceId.put("2", "u-2");
    }

    @Test
    public void testDeleteAclsWithUserResource() {
        userMetaDataStore = (DefaultUserMetaDataStore)Mockito.mock(DefaultUserMetaDataStore.class);
        for (String id : userAndResourceIds) {
            Mockito.when((Object)userMetaDataStore.userResourceIdToUserId(id)).thenReturn(Optional.ofNullable(userResourceIdToUserId.get(id)));
            Mockito.when((Object)userMetaDataStore.userIdToUserResourceId(id)).thenReturn(Optional.ofNullable(userIdToUserResourceId.get(id)));
        }
        ArrayList<AclBindingFilter> aclBindingFilters = new ArrayList<AclBindingFilter>();
        ArrayList<CompletableFuture<AclDeleteResult>> aclDeleteResults = new ArrayList<CompletableFuture<AclDeleteResult>>();
        ArrayList<CompletableFuture<AclDeleteResult>> convertedAclDeleteResults = new ArrayList<CompletableFuture<AclDeleteResult>>();
        aclBindingFilters.add(this.getAclBindindFilter(this.principal("2")));
        aclDeleteResults.add(this.getAclDeleteResult(this.principal("2"), 3));
        convertedAclDeleteResults.add(this.getAclDeleteResult(this.principal("u-2"), 2));
        aclBindingFilters.add(this.getAclBindindFilter(this.principal("u-2")));
        aclDeleteResults.add(this.getAclDeleteResult(this.principal("u-2"), 3));
        convertedAclDeleteResults.add(this.getAclDeleteResult(this.principal("2"), 2));
        aclBindingFilters.add(AclBindingFilter.ANY);
        Collection<AclDeleteResult.AclBindingDeleteResult> aclBindingDeleteResults = this.getAclBindingDeleteResult(this.principal("u-2"), 2);
        aclBindingDeleteResults.addAll(this.getAclBindingDeleteResult(this.principal("2"), 1));
        aclBindingDeleteResults.addAll(this.getAclBindingDeleteResult(this.principal("3"), 1));
        aclBindingDeleteResults.addAll(this.getAclBindingDeleteResult(this.principal("u-3"), 1));
        aclDeleteResults.add(CompletableFuture.completedFuture(new AclDeleteResult(aclBindingDeleteResults)));
        convertedAclDeleteResults.add(CompletableFuture.completedFuture(new AclDeleteResult(this.getAclBindingDeleteResult("User:*", 0))));
        aclBindingFilters.add(this.getAclBindindFilter("UserV2:*"));
        aclDeleteResults.add(CompletableFuture.completedFuture(new AclDeleteResult(this.getAclBindingDeleteResult("User:*", 0))));
        convertedAclDeleteResults.add(CompletableFuture.completedFuture(new AclDeleteResult(aclBindingDeleteResults)));
        aclBindingFilters.add(this.getAclBindindFilter(this.principal("2")));
        aclDeleteResults.add(CompletableFuture.completedFuture(new AclDeleteResult(new ApiException("Ran into exception while deleting the ACLs"))));
        convertedAclDeleteResults.add(this.getAclDeleteResult(this.principal("u-2"), 5));
        MultiTenantAuthorizer multiTenantAuthorizer = new MultiTenantAuthorizer();
        multiTenantAuthorizer.updateUserMetaDataStore(userMetaDataStore);
        multiTenantAuthorizer.tenantAuthorizerMetrics();
        List finalResults = multiTenantAuthorizer.combineAclDeleteResults(aclBindingFilters, aclDeleteResults, convertedAclDeleteResults);
        Assertions.assertTrue((finalResults.size() == 5 ? 1 : 0) != 0);
        for (int i = 0; i < 4; ++i) {
            int finalI = i;
            Assertions.assertFalse((boolean)((CompletableFuture)((CompletableFuture)finalResults.get(i)).thenAccept(aclDeleteResult -> {
                Assertions.assertTrue((aclDeleteResult.aclBindingDeleteResults().size() == 5 ? 1 : 0) != 0);
                Set principals = aclDeleteResult.aclBindingDeleteResults().stream().map(aclBindingDeleteResult -> aclBindingDeleteResult.aclBinding().entry().principal()).collect(Collectors.toSet());
                switch (finalI) {
                    case 0: {
                        Assertions.assertTrue((principals.size() == 1 && principals.contains(this.principal("2")) ? 1 : 0) != 0);
                        break;
                    }
                    case 1: {
                        Assertions.assertTrue((principals.size() == 1 && principals.contains(this.principal("u-2")) ? 1 : 0) != 0);
                        break;
                    }
                    case 2: {
                        Assertions.assertTrue((principals.size() == 3 && principals.containsAll(Arrays.asList(this.principal("2"), this.principal("3"), this.principal("u-3"))) && !principals.contains("u-2") ? 1 : 0) != 0);
                        break;
                    }
                    case 3: {
                        Assertions.assertTrue((principals.size() == 3 && principals.containsAll(Arrays.asList(this.principal("u-2"), this.principal("3"), this.principal("u-3"))) && !principals.contains("2") ? 1 : 0) != 0);
                    }
                }
            })).isCompletedExceptionally());
        }
        Assertions.assertFalse((boolean)((CompletableFuture)((CompletableFuture)finalResults.get(4)).thenAccept(aclDeleteResult -> Assertions.assertTrue((aclDeleteResult.aclBindingDeleteResults().size() == 0 && aclDeleteResult.exception() != null ? 1 : 0) != 0))).isCompletedExceptionally());
        Assertions.assertTrue((TestUtils.getMetricValue((Metrics)multiTenantAuthorizer.metrics(), (String)"user-id-to-resource-id-mapping-missing-rate-per-minute") >= 3.0 ? 1 : 0) != 0);
    }

    @Test
    public void testAclLimit() {
        final ArrayList<AclBinding> existingAcls = new ArrayList<AclBinding>();
        final AtomicInteger describeCount = new AtomicInteger();
        MultiTenantAuthorizer authorizer = new MultiTenantAuthorizer(){

            public Iterable<AclBinding> acls(AclBindingFilter filter) {
                describeCount.incrementAndGet();
                return existingAcls;
            }
        };
        String prefix = "tenant_";
        ArrayList<AclBinding> newAcls = new ArrayList<AclBinding>();
        this.setAcls(existingAcls, prefix, 0, 10, new Uuid[0]);
        this.setAcls(newAcls, prefix, 11, 20, new Uuid[0]);
        Assertions.assertFalse((boolean)authorizer.exceedsAclLimit(prefix, newAcls, Integer.MAX_VALUE));
        Assertions.assertEquals((int)0, (int)describeCount.get());
        existingAcls.clear();
        this.verifyLimit(authorizer, prefix, 0, 10, 10, false);
        this.setAcls(existingAcls, prefix, 0, 5, new Uuid[0]);
        this.verifyLimit(authorizer, prefix, 5, 5, 10, false);
        this.setAcls(existingAcls, "another-tenant", 0, 20, new Uuid[0]);
        this.verifyLimit(authorizer, prefix, 0, 10, 10, false);
        this.setAcls(existingAcls, prefix, 0, 10, new Uuid[0]);
        this.verifyLimit(authorizer, prefix, 0, 10, 10, false);
        this.setAcls(existingAcls, prefix, 0, 9, new Uuid[0]);
        this.verifyLimit(authorizer, prefix, 20, 1, 10, false);
        this.setAcls(existingAcls, prefix, 0, 10, new Uuid[0]);
        this.verifyLimit(authorizer, prefix, 20, 1, 10, true);
        this.setAcls(existingAcls, prefix, 0, 9, new Uuid[0]);
        this.verifyLimit(authorizer, prefix, 20, 2, 10, true);
        this.setAcls(existingAcls, prefix, 0, 10, Uuid.randomUuid(), Uuid.randomUuid());
        this.verifyLimit(authorizer, prefix, 0, 10, 10, false);
        this.setAcls(existingAcls, prefix, 0, 20, Uuid.randomUuid(), Uuid.randomUuid());
        this.setAcls(newAcls, prefix, 0, 20, new Uuid[0]);
        this.verifyLimit(authorizer, prefix, 0, 20, 10, false);
    }

    @Test
    public void testAclOperationMetric() {
        MultiTenantAuthorizer multiTenantAuthorizer = new MultiTenantAuthorizer();
        multiTenantAuthorizer.tenantAuthorizerMetrics();
        multiTenantAuthorizer.recordCreateAclMetric("User:*");
        multiTenantAuthorizer.recordDescribeAclMetric("UserV2:*");
        multiTenantAuthorizer.recordDeleteAclMetric("User:sa-1");
        multiTenantAuthorizer.recordCreateAclMetric(null);
        multiTenantAuthorizer.recordDescribeAclMetric("User:1");
        multiTenantAuthorizer.recordDeleteAclMetric("User:1");
        for (String principalType : new String[]{"integer-id", "resource-id"}) {
            Assertions.assertTrue((TestUtils.getMetricValue((Metrics)multiTenantAuthorizer.metrics(), (String)"create-acl-request-rate", Collections.singletonMap("principal-type", principalType)) > 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((TestUtils.getMetricValue((Metrics)multiTenantAuthorizer.metrics(), (String)"describe-acl-request-rate", Collections.singletonMap("principal-type", principalType)) > 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((TestUtils.getMetricValue((Metrics)multiTenantAuthorizer.metrics(), (String)"delete-acl-request-rate", Collections.singletonMap("principal-type", principalType)) > 0.0 ? 1 : 0) != 0);
        }
    }

    private void setAcls(List<AclBinding> aclList, String prefix, int startIndex, int count, Uuid ... linkIds) {
        aclList.clear();
        String principal = "TenantUser:" + prefix + "*";
        for (int i = 0; i < count; ++i) {
            int index = startIndex + i;
            ResourcePattern pattern = new ResourcePattern(ResourceType.TOPIC, prefix + "topic" + index, PatternType.LITERAL);
            AccessControlEntry ace = new AccessControlEntry(principal, "", AclOperation.ALL, AclPermissionType.ALLOW, Arrays.asList(linkIds));
            aclList.add(new AclBinding(pattern, ace));
        }
    }

    private void verifyLimit(MultiTenantAuthorizer authorizer, String prefix, int newAclStart, int newAclCount, int limit, boolean overLimit) {
        ArrayList<AclBinding> newAcls = new ArrayList<AclBinding>();
        this.setAcls(newAcls, prefix, newAclStart, newAclCount, new Uuid[0]);
        Assertions.assertEquals((Object)overLimit, (Object)authorizer.exceedsAclLimit(prefix, newAcls, limit));
        this.setAcls(newAcls, prefix, newAclStart, newAclCount, Uuid.randomUuid());
        Assertions.assertEquals((Object)overLimit, (Object)authorizer.exceedsAclLimit(prefix, newAcls, limit));
        this.setAcls(newAcls, prefix, newAclStart, newAclCount, Uuid.randomUuid(), Uuid.randomUuid());
        Assertions.assertEquals((Object)overLimit, (Object)authorizer.exceedsAclLimit(prefix, newAcls, limit));
        this.setAcls(newAcls, prefix, newAclStart, newAclCount, Uuid.ZERO_UUID);
        Assertions.assertEquals((Object)overLimit, (Object)authorizer.exceedsAclLimit(prefix, newAcls, limit));
    }

    private String principal(String user) {
        return prefixPrincipal + user;
    }

    private CompletableFuture<AclDeleteResult> getAclDeleteResult(String principal, int numOfAclBindingDeleteResults) {
        return CompletableFuture.completedFuture(new AclDeleteResult(this.getAclBindingDeleteResult(principal, numOfAclBindingDeleteResults)));
    }

    private Collection<AclDeleteResult.AclBindingDeleteResult> getAclBindingDeleteResult(String principal, int numOfAclBindingDeleteResults) {
        ArrayList<AclDeleteResult.AclBindingDeleteResult> aclBindingDeleteResults = new ArrayList<AclDeleteResult.AclBindingDeleteResult>();
        for (int i = 0; i < numOfAclBindingDeleteResults; ++i) {
            aclBindingDeleteResults.add(new AclDeleteResult.AclBindingDeleteResult(this.getAclBinding(principal)));
        }
        return aclBindingDeleteResults;
    }

    private AclBinding getAclBinding(String principal) {
        return new AclBinding(new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL), new AccessControlEntry(principal, "*", AclOperation.ALL, AclPermissionType.ALLOW));
    }

    private AclBindingFilter getAclBindindFilter(String principal) {
        return new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(principal, null, AclOperation.ANY, AclPermissionType.ANY));
    }
}

