/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.common.multitenant.oauth.OAuthBearerJwsToken;
import io.confluent.kafka.multitenant.IdentityMetadata;
import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.MultiTenantSaslServer;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.UserTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.security.sasl.SaslServer;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.constraints.AlphaChars;
import net.jqwik.api.constraints.Chars;
import net.jqwik.api.constraints.NumericChars;
import net.jqwik.api.constraints.StringLength;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.message.ConfluentBrokenPrincipalData;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class MultiTenantPrincipalBuilderTest {
    private static final String OAUTH_NEGOTIATED_TOKEN_PROPERTY_KEY = "OAUTHBEARER.token";
    private static final String BROKER_UUID = UUID.randomUUID().toString();
    private static Map<String, Object> configs;
    private static PhysicalClusterMetadata metadata;
    private SaslAuthenticationContext context;
    public static final Path TEMP_DIR;

    @BeforeAll
    public static void setUp() throws Exception {
        MultiTenantPrincipalBuilderTest.setUpPhysicalMetadata();
        MultiTenantPrincipalBuilderTest.clearYammerMetrics();
    }

    @AfterAll
    public static void tearDown() throws Exception {
        metadata.close(BROKER_UUID);
    }

    @BeforeEach
    public void clearConfig() {
        configs.remove("multitenant.oauth.superuser.disable");
        configs.remove("confluent.metadata.kafka.enable.dataplane.rbac");
    }

    private static void setUpPhysicalMetadata() throws IOException, InterruptedException {
        configs = new HashMap<String, Object>();
        configs.put("principal.builder.class", MultiTenantPrincipalBuilder.class);
        configs.put("broker.session.uuid", BROKER_UUID);
        configs.put("multitenant.metadata.dir", TEMP_DIR.toRealPath(new LinkOption[0]));
        metadata = Utils.initiatePhysicalClusterMetadata(configs);
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, TEMP_DIR);
        Utils.createLogicalClusterFile(Utils.LC_META_1, TEMP_DIR);
        Utils.createLogicalClusterFile(Utils.LC_META_HEALTHCHECK, TEMP_DIR);
        Utils.createLogicalClusterFile(Utils.LC_META_LINK_HEALTHCHECK, TEMP_DIR);
        TestUtils.waitForCondition(() -> metadata.metadata(Utils.LC_META_LINK_HEALTHCHECK.logicalClusterId()) != null, (String)"Expected metadata of new logical cluster to be present in metadata cache");
    }

    @Test
    public void testOauthSaslPrincipalIsSuperuserByDefault() {
        this.mockOAuthSaslContext(Utils.LC_META_ABC.logicalClusterId());
        this.verifyTenantMetadata(Utils.LC_META_ABC, true);
    }

    @Test
    public void testOauthSaslPrincipalIsSuperuserByDefaultForInternalUsers() {
        this.mockOAuthSaslContext(Utils.LC_META_ABC.logicalClusterId(), true);
        this.verifyTenantMetadata(Utils.LC_META_ABC, true);
    }

    @Test
    public void testOauthSaslPrincipalIsNotSuperuserWhenMultitenantOauthSuperuserDisableIsTrue() {
        this.mockOAuthSaslContext(Utils.LC_META_ABC.logicalClusterId());
        configs.put("multitenant.oauth.superuser.disable", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, false);
    }

    @Test
    public void testOauthSaslPrincipalIsNotSuperuserWhenRBACEnabled() {
        this.mockOAuthSaslContext(Utils.LC_META_ABC.logicalClusterId());
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, false);
    }

    @Test
    public void testOauthSaslPrincipalIsNotSuperuserWhenBothFlagsEnabled() {
        this.mockOAuthSaslContext(Utils.LC_META_ABC.logicalClusterId());
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        configs.put("multitenant.oauth.superuser.disable", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, false);
    }

    @Test
    public void testOauthSaslPrincipalIsSuperuserWhenMultitenantOauthSuperuserDisableIsTrueForInternalUsers() {
        this.mockOAuthSaslContext(Utils.LC_META_ABC.logicalClusterId(), true);
        configs.put("multitenant.oauth.superuser.disable", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, true);
    }

    @Test
    public void testOauthSaslPrincipalIsSuperuserWhenRBACEnabledForInternalUsers() {
        this.mockOAuthSaslContext(Utils.LC_META_ABC.logicalClusterId(), true);
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, true);
    }

    @Test
    public void testOauthSaslOrgMissingProps() {
        this.mockOAuthSaslContext(Utils.LC_META_1.logicalClusterId());
        this.verifyOrgPropsMetric();
    }

    @Test
    public void testPlainSaslOrgMissingProps() {
        this.mockPlainSaslContext(Utils.LC_META_1.logicalClusterId(), true);
        this.verifyOrgPropsMetric();
    }

    @Test
    public void testPlainSaslPrincipalIsSuperuserByDefaultForUserAccount() {
        this.mockPlainSaslContext(Utils.LC_META_ABC.logicalClusterId(), true);
        this.verifyTenantMetadata(Utils.LC_META_ABC, true);
    }

    @Test
    public void testPlainSaslPrincipalIsNotSuperuserWhenRBACEnabledForUserAccount() {
        this.mockPlainSaslContext(Utils.LC_META_ABC.logicalClusterId(), true);
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, false);
    }

    @Test
    public void testPlainSaslPrincipalIsSuperuserWhenMultitenantOauthSuperuserDisableIsTrueForUserAccount() {
        this.mockPlainSaslContext(Utils.LC_META_ABC.logicalClusterId(), true);
        configs.put("multitenant.oauth.superuser.disable", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, true);
    }

    @Test
    public void testPlainSaslPrincipalIsSuperuserWhenBothFlagsEnabledForUserAccount() {
        this.mockPlainSaslContext(Utils.LC_META_ABC.logicalClusterId(), true);
        configs.put("multitenant.oauth.superuser.disable", "true");
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, false);
    }

    @Test
    public void testPlainSaslPrincipalIsSuperuserForInternalUsersWhenRBACEnabledForUserAccount() {
        this.mockPlainSaslContext(Utils.LC_META_ABC.logicalClusterId(), true, true);
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, true);
    }

    @Test
    public void testPlainSaslPrincipalIsNotSuperuserByDefaultForServiceAccount() {
        this.mockPlainSaslContext(Utils.LC_META_ABC.logicalClusterId(), false);
        this.verifyTenantMetadata(Utils.LC_META_ABC, false);
    }

    @Test
    public void testPlainSaslPrincipalIsNotSuperuserWhenRBACEnabledForServiceAccount() {
        this.mockPlainSaslContext(Utils.LC_META_ABC.logicalClusterId(), false);
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, false);
    }

    @Test
    public void testPlainSaslPrincipalIsNotSuperuserWhenWhenMultitenantOauthSuperuserDisableIsTrueForServiceAccount() {
        this.mockPlainSaslContext(Utils.LC_META_ABC.logicalClusterId(), false);
        configs.put("multitenant.oauth.superuser.disable", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, false);
    }

    @Test
    public void testPlainSaslPrincipalIsNotSuperuserWhenBothFlagsEnabledForServiceAccount() {
        this.mockPlainSaslContext(Utils.LC_META_ABC.logicalClusterId(), false);
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        configs.put("multitenant.oauth.superuser.disable", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, false);
    }

    @Test
    public void testPlainSaslPrincipalIsNotSuperuserForInternalUsersWhenRBACEnabledForServiceAccount() {
        this.mockPlainSaslContext(Utils.LC_META_ABC.logicalClusterId(), false, true);
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        this.verifyTenantMetadata(Utils.LC_META_ABC, false);
    }

    @Test
    public void testHCPrincipalIsSuperuser() {
        this.mockPlainSaslContext(Utils.LC_META_HEALTHCHECK.logicalClusterId(), true, true);
        this.verifyTenantMetadata(Utils.LC_META_HEALTHCHECK, true);
    }

    @Test
    public void testHCPrincipalIsSuperuserWhenRBACEnabled() {
        this.mockPlainSaslContext(Utils.LC_META_LINK_HEALTHCHECK.logicalClusterId(), true, true);
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        this.verifyTenantMetadata(Utils.LC_META_LINK_HEALTHCHECK, true);
    }

    @Test
    public void testHCPrincipalIsSuperuserWhenMultitenantOauthSuperuserDisableIsTrue() {
        this.mockPlainSaslContext(Utils.LC_META_HEALTHCHECK.logicalClusterId(), true, true);
        configs.put("multitenant.oauth.superuser.disable", "true");
        this.verifyTenantMetadata(Utils.LC_META_HEALTHCHECK, true);
    }

    @Test
    public void testHCPrincipalIsSuperuserWhenBothFlagsTrue() {
        this.mockPlainSaslContext(Utils.LC_META_LINK_HEALTHCHECK.logicalClusterId(), true, true);
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        configs.put("multitenant.oauth.superuser.disable", "true");
        this.verifyTenantMetadata(Utils.LC_META_LINK_HEALTHCHECK, true);
    }

    @Test
    public void testHCOauthPrincipalIsSuperuser() {
        this.mockOAuthSaslContext(Utils.LC_META_HEALTHCHECK.logicalClusterId());
        this.verifyTenantMetadata(Utils.LC_META_HEALTHCHECK, true);
    }

    @Test
    public void testHCOauthPrincipalIsSuperuserWhenRBACEnabled() {
        this.mockOAuthSaslContext(Utils.LC_META_LINK_HEALTHCHECK.logicalClusterId());
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        this.verifyTenantMetadata(Utils.LC_META_LINK_HEALTHCHECK, true);
    }

    @Test
    public void testHCOauthPrincipalIsSuperuserWhenMultitenantOauthSuperuserDisableIsTrue() {
        this.mockOAuthSaslContext(Utils.LC_META_HEALTHCHECK.logicalClusterId());
        configs.put("multitenant.oauth.superuser.disable", "true");
        this.verifyTenantMetadata(Utils.LC_META_HEALTHCHECK, true);
    }

    @Test
    public void testHCOauthPrincipalIsSuperuserWhenBothFlagsTrue() {
        this.mockOAuthSaslContext(Utils.LC_META_LINK_HEALTHCHECK.logicalClusterId());
        configs.put("confluent.metadata.kafka.enable.dataplane.rbac", "true");
        configs.put("multitenant.oauth.superuser.disable", "true");
        this.verifyTenantMetadata(Utils.LC_META_LINK_HEALTHCHECK, true);
    }

    @Test
    public void testOauthServiceAccountIsNotSuperUser() {
        this.mockOAuthSaslContext(Utils.LC_META_ABC.logicalClusterId(), "12345", "sa-foo");
        this.verifyTenantMetadata(Utils.LC_META_ABC, false);
    }

    @Test
    public void testMultiTenantPrincipalBuilderSerde_NonMultiTenant() {
        KafkaPrincipal p = new KafkaPrincipal("User", "user");
        MultiTenantPrincipalBuilder mtBuilder = new MultiTenantPrincipalBuilder();
        KafkaPrincipal copy = mtBuilder.deserialize(mtBuilder.serialize(p));
        Assertions.assertEquals((Object)p, (Object)copy);
    }

    @Test
    public void testMultiTenantPrincipalBuilderSerde_NonMultiTenantCompatibilityWithDefaultKafkaPrincipalBuilder() {
        KafkaPrincipal p = new KafkaPrincipal("User", "user");
        DefaultKafkaPrincipalBuilder defaultSerializer = new DefaultKafkaPrincipalBuilder(null, null);
        MultiTenantPrincipalBuilder mtDeserializer = new MultiTenantPrincipalBuilder();
        KafkaPrincipal copy = mtDeserializer.deserialize(defaultSerializer.serialize(p));
        Assertions.assertEquals((Object)p, (Object)copy);
    }

    @Test
    public void testMultiTenantPrincipalBuilderSerde_MultiTenant() {
        MultiTenantPrincipalBuilder builder = new MultiTenantPrincipalBuilder();
        MultiTenantPrincipal p = new MultiTenantPrincipal("user", "saslAuthenticationId", new TenantMetadata("tenantName", "clusterId", "organizationId", "environmentId", "userResourceID", true, true, true));
        Assertions.assertEquals((Object)"TenantUser", (Object)p.getPrincipalType());
        KafkaPrincipal copy = builder.deserialize(builder.serialize((KafkaPrincipal)p));
        Assertions.assertEquals((Object)p, (Object)copy);
        MultiTenantPrincipal mtp = (MultiTenantPrincipal)copy;
        Assertions.assertEquals((Object)p.tenantMetadata().userResourceId, (Object)mtp.tenantMetadata().userResourceId);
        Assertions.assertEquals((Object)p.tenantMetadata().isServiceAccount, (Object)mtp.tenantMetadata().isServiceAccount);
        Assertions.assertEquals((Object)p.tenantMetadata().isHealthcheckTenant, (Object)mtp.tenantMetadata().isHealthcheckTenant);
        Assertions.assertEquals((Object)p.tenantMetadata().isApiKeyAuthenticated, (Object)mtp.tenantMetadata().isApiKeyAuthenticated);
        Assertions.assertEquals((Object)p.identityMetadata().poolId(), (Object)mtp.identityMetadata().poolId());
        Assertions.assertNull((Object)p.identityMetadata().poolId());
        Assertions.assertEquals((Object)p.authorizationIds(), (Object)mtp.authorizationIds());
        Assertions.assertTrue((boolean)p.authorizationIds().contains("userResourceID"));
        MultiTenantPrincipalBuilder builder2 = new MultiTenantPrincipalBuilder();
        MultiTenantPrincipal p2 = new MultiTenantPrincipal("user", "saslAuthenticationId", Optional.empty(), new TenantMetadata("tenantName", "clusterId", "organizationId", "environmentId", "userResourceID", true, true, true), new IdentityMetadata("poolId", "providerId", "serviceAccount", "externalIdentityId"), Arrays.asList("userResourceId", "poolId1", "poolId2"));
        Assertions.assertEquals((Object)"TenantUser", (Object)p2.getPrincipalType());
        KafkaPrincipal copy2 = builder2.deserialize(builder2.serialize((KafkaPrincipal)p2));
        Assertions.assertEquals((Object)p2, (Object)copy2);
        MultiTenantPrincipal mtp2 = (MultiTenantPrincipal)copy2;
        Assertions.assertEquals((Object)p2.tenantMetadata().userResourceId, (Object)mtp2.tenantMetadata().userResourceId);
        Assertions.assertEquals((Object)p2.tenantMetadata().isServiceAccount, (Object)mtp2.tenantMetadata().isServiceAccount);
        Assertions.assertEquals((Object)p2.tenantMetadata().isHealthcheckTenant, (Object)mtp2.tenantMetadata().isHealthcheckTenant);
        Assertions.assertEquals((Object)p2.tenantMetadata().isApiKeyAuthenticated, (Object)mtp2.tenantMetadata().isApiKeyAuthenticated);
        Assertions.assertEquals((Object)p2.identityMetadata().poolId(), (Object)mtp2.identityMetadata().poolId());
        Assertions.assertEquals((Object)"poolId", (Object)p2.identityMetadata().poolId());
        Assertions.assertEquals((Object)p2.authorizationIds(), (Object)mtp2.authorizationIds());
        Assertions.assertTrue((boolean)mtp2.authorizationIds().containsAll(Arrays.asList("userResourceId", "poolId1", "poolId2")));
        Assertions.assertEquals((Object)"externalIdentityId", (Object)p2.identityMetadata().externalIdentityId());
    }

    @Test
    public void testMultiTenantPrincipalBuilderSerde_RejectsBadType() throws Exception {
        MultiTenantPrincipalBuilder serde = new MultiTenantPrincipalBuilder();
        Arrays.asList("Group", "whatever").forEach(principalType -> {
            SerializationException e = (SerializationException)Assertions.assertThrows(SerializationException.class, () -> serde.deserialize(serde.serialize(new KafkaPrincipal(principalType, "foo"))));
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Invalid principal type "));
        });
    }

    @Test
    public void testUserTenantPrincipalBuilderSerde() {
        UserTenantPrincipalBuilder builder = new UserTenantPrincipalBuilder();
        MultiTenantPrincipal p = (MultiTenantPrincipal)builder.build(null);
        Assertions.assertEquals((Object)"TenantUser", (Object)p.getPrincipalType());
        KafkaPrincipal copy = builder.deserialize(builder.serialize((KafkaPrincipal)p));
        Assertions.assertEquals((Object)p, (Object)copy);
        MultiTenantPrincipal mtp = (MultiTenantPrincipal)copy;
        Assertions.assertEquals((Object)p.tenantMetadata().userResourceId, (Object)mtp.tenantMetadata().userResourceId);
        Assertions.assertEquals((Object)p.tenantMetadata().isServiceAccount, (Object)mtp.tenantMetadata().isServiceAccount);
        Assertions.assertEquals((Object)p.tenantMetadata().isHealthcheckTenant, (Object)mtp.tenantMetadata().isHealthcheckTenant);
        Assertions.assertEquals((Object)p.tenantMetadata().isApiKeyAuthenticated, (Object)mtp.tenantMetadata().isApiKeyAuthenticated);
        Assertions.assertEquals((Object)p.authorizationIds(), (Object)mtp.authorizationIds());
        Assertions.assertTrue((boolean)p.authorizationIds().contains(mtp.tenantMetadata().userResourceId));
    }

    @Property(tries=5000)
    public void testBrokenSchemaFailsParsing(@ForAll @StringLength(min=1) @StringLength(min=1) String username, @ForAll @StringLength(min=1) @AlphaChars @NumericChars @Chars(value={46, 45}) @StringLength(min=1) @AlphaChars @NumericChars @Chars(value={46, 45}) String tenant, @ForAll @StringLength(min=1) @StringLength(min=1) String clusterId, @ForAll String saslAuthenticationId, @ForAll boolean isTokenAuthenticated, @ForAll String organizationId, @ForAll String environmentId, @ForAll String userResourceId, @ForAll boolean isServiceAccount, @ForAll boolean isApiKeyAuthenticated, @ForAll boolean isHealthcheckTenant) {
        ConfluentBrokenPrincipalData data = new ConfluentBrokenPrincipalData().setType("TenantUser").setName(username).setTokenAuthenticated(isTokenAuthenticated).setTenantName(tenant).setClusterId(clusterId).setOrganizationId(organizationId).setEnvironmentId(environmentId).setServiceAccount(isServiceAccount).setApiKeyAuthenticated(isApiKeyAuthenticated).setHealthcheckTenant(isHealthcheckTenant).setUserResourceId(userResourceId).setSaslAuthenticationId(saslAuthenticationId);
        byte[] principalBytes = MessageUtil.toVersionPrefixedBytes((short)0, (Message)data);
        UserTenantPrincipalBuilder builder = new UserTenantPrincipalBuilder();
        Assertions.assertThrows(SerializationException.class, () -> builder.deserialize(principalBytes));
    }

    private void verifyTenantMetadata(KafkaLogicalClusterMetadata lkcMetadata, boolean expectedSuperUser) {
        MultiTenantPrincipal principal = (MultiTenantPrincipal)ChannelBuilders.createPrincipalBuilder(configs, null, null).build((AuthenticationContext)this.context);
        Assertions.assertEquals((Object)lkcMetadata.logicalClusterId(), (Object)principal.tenantMetadata().clusterId);
        Assertions.assertEquals((Object)lkcMetadata.organizationId(), (Object)principal.tenantMetadata().organizationId);
        Assertions.assertEquals((Object)lkcMetadata.environmentId(), (Object)principal.tenantMetadata().environmentId);
        Scope expectedScope = new Scope.Builder(new String[0]).addPath("organization=" + lkcMetadata.organizationId()).addPath("environment=" + lkcMetadata.environmentId()).addPath("cloud-cluster=" + lkcMetadata.logicalClusterId()).withKafkaCluster(lkcMetadata.logicalClusterId()).build();
        Assertions.assertEquals((Object)expectedScope, (Object)principal.tenantMetadata().scope());
        String sameTenant = principal.tenantMetadata().clusterId + "_";
        Action action = new Action(Scope.kafkaClusterScope((String)"foo"), ResourceType.ALL, sameTenant, Operation.ALL);
        boolean enableDataplaneRbacForPkc = "true".equals(configs.get("confluent.metadata.kafka.enable.dataplane.rbac"));
        boolean oauthSuperUserDisabled = "true".equals(configs.get("multitenant.oauth.superuser.disable"));
        Assertions.assertEquals((Object)expectedSuperUser, (Object)MultiTenantAuthorizer.isSuperUser((MultiTenantPrincipal)principal, (Action)action, (boolean)false, (boolean)enableDataplaneRbacForPkc, (boolean)oauthSuperUserDisabled));
    }

    private void mockOAuthSaslContext(String clusterId) {
        this.mockOAuthSaslContext(clusterId, false, true);
    }

    private void mockOAuthSaslContext(String clusterId, boolean internalUser) {
        this.mockOAuthSaslContext(clusterId, internalUser, true);
    }

    private void mockOAuthSaslContext(String clusterId, boolean internalUser, boolean withUserResourceId) {
        String userId = internalUser ? "0" : "user";
        String userResourceId = withUserResourceId ? userId : null;
        this.mockOAuthSaslContext(clusterId, userId, userResourceId);
    }

    private void mockOAuthSaslContext(String clusterId, String userId, String userResourceId) {
        SaslServer saslServer = (SaslServer)Mockito.mock(OAuthBearerSaslServer.class);
        if (userResourceId != null) {
            Mockito.when((Object)saslServer.getNegotiatedProperty(OAUTH_NEGOTIATED_TOKEN_PROPERTY_KEY)).thenReturn((Object)new OAuthBearerJwsToken("", null, 0L, userId, Long.valueOf(0L), Collections.singletonMap("userResourceId", userResourceId)));
        } else {
            Mockito.when((Object)saslServer.getNegotiatedProperty(OAUTH_NEGOTIATED_TOKEN_PROPERTY_KEY)).thenReturn((Object)new OAuthBearerJwsToken("", null, 0L, userId, Long.valueOf(0L)));
        }
        Mockito.when((Object)saslServer.getNegotiatedProperty("logicalCluster")).thenReturn((Object)clusterId);
        this.context = new SaslAuthenticationContext(saslServer, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLoopbackAddress(), SecurityProtocol.SASL_PLAINTEXT.name());
    }

    private void mockPlainSaslContext(String clusterId, boolean userAccount) {
        this.mockPlainSaslContext(clusterId, userAccount, false, true);
    }

    private void mockPlainSaslContext(String clusterId, boolean userAccount, boolean internalUser) {
        this.mockPlainSaslContext(clusterId, userAccount, internalUser, true);
    }

    private void mockPlainSaslContext(String clusterId, boolean userAccount, boolean internalUser, boolean withUserResourceId) {
        boolean healthcheckTenant = Utils.LC_META_HEALTHCHECK.equals((Object)clusterId) || Utils.LC_META_LINK_HEALTHCHECK.equals((Object)clusterId);
        String user = internalUser ? "0" : "user";
        MultiTenantSaslServer saslServer = (MultiTenantSaslServer)Mockito.mock(MultiTenantSaslServer.class);
        TenantMetadata tenantMetadata = withUserResourceId ? new TenantMetadata.Builder(clusterId, "u-" + user).serviceAccount(!userAccount).healthcheckTenant(healthcheckTenant).apiKeyAuthenticated(true).build() : new TenantMetadata.Builder(clusterId, null).serviceAccount(!userAccount).healthcheckTenant(healthcheckTenant).apiKeyAuthenticated(true).build();
        Mockito.when((Object)saslServer.tenantMetadata()).thenReturn((Object)tenantMetadata);
        Mockito.when((Object)saslServer.getAuthorizationID()).thenReturn((Object)user);
        this.context = new SaslAuthenticationContext((SaslServer)saslServer, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLoopbackAddress(), SecurityProtocol.SASL_PLAINTEXT.name());
    }

    private void verifyOrgPropsMetric() {
        for (int i = 0; i < 10; ++i) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)ChannelBuilders.createPrincipalBuilder(configs, null, null).build((AuthenticationContext)this.context);
        }
        List orgPropsMetrics = KafkaYammerMetrics.defaultRegistry().allMetrics().entrySet().stream().filter(e -> ((MetricName)e.getKey()).getName().equals("org-props-missing-rate")).map(Map.Entry::getValue).collect(Collectors.toList());
        Assertions.assertTrue((orgPropsMetrics.size() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue(((int)((Meter)orgPropsMetrics.get(0)).count() >= 10 ? 1 : 0) != 0);
    }

    private static void clearYammerMetrics() {
        for (MetricName metricName : KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()) {
            KafkaYammerMetrics.defaultRegistry().removeMetric(metricName);
        }
    }

    static {
        TEMP_DIR = TestUtils.tempDirectory().toPath();
    }
}

