/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.multitenant.schema.TenantContext;
import io.confluent.kafka.server.plugins.policy.TopicPolicyConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kafka.common.TenantHelpers;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.GaugeSuite;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.ConfluentPartitionsPerTopicListener;
import org.apache.kafka.server.interceptor.Monitorable;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTopicPolicy
implements org.apache.kafka.server.policy.CreateTopicPolicy,
ConfluentPartitionsPerTopicListener,
Monitorable,
Reconfigurable {
    private static final Logger log = LoggerFactory.getLogger(CreateTopicPolicy.class);
    private static final Set<String> RECONFIGURABLE_CONFIGS = ImmutableSet.of((Object)"confluent.plugins.topic.policy.max.partitions.per.tenant");
    private short requiredRepFactor;
    private int maxPartitionsPerTenant;
    private TopicPolicyConfig policyConfig;
    private Map<String, Integer> tenantToNumPartitions;
    private final Object metadataLock = new Object();
    private GaugeSuite<String, Integer> partitionsByTenantMetrics;
    private final Object metricsLock = new Object();

    public void configure(Map<String, ?> configs) {
        this.reconfigure(configs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMetrics(Metrics metrics) {
        Object object = this.metricsLock;
        synchronized (object) {
            this.partitionsByTenantMetrics = new GaugeSuite(log, "partitions", metrics, tenant -> metrics.metricName("partitions", "tenant-metrics", "The total number of partitions for this tenant.", Collections.singletonMap("tenant", tenant)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(CreateTopicPolicy.RequestMetadata reqMetadata) throws PolicyViolationException {
        int cur;
        int max;
        TopicPolicyConfig policy;
        String tenant = TenantHelpers.extractTenantPrefix((String)reqMetadata.topic(), (boolean)false);
        if (tenant == null) {
            return;
        }
        try {
            Topic.validate((String)TenantContext.removePrefix(reqMetadata.topic()));
        }
        catch (InvalidTopicException e) {
            throw new PolicyViolationException("Invalid topic name specified.");
        }
        Integer numPartitionsPassed = reqMetadata.numPartitions();
        if (reqMetadata.replicasAssignments() != null && !reqMetadata.replicasAssignments().isEmpty()) {
            numPartitionsPassed = reqMetadata.replicasAssignments().keySet().size();
        }
        if (numPartitionsPassed == null) {
            throw new PolicyViolationException("Must specify number of partitions.");
        }
        Short repFactorPassed = reqMetadata.replicationFactor();
        if (reqMetadata.replicasAssignments() != null && !reqMetadata.replicasAssignments().isEmpty()) {
            repFactorPassed = (short)((List)reqMetadata.replicasAssignments().values().iterator().next()).size();
        }
        if (repFactorPassed != null && repFactorPassed != this.requiredRepFactor) {
            throw new PolicyViolationException("Topic replication factor must be " + this.requiredRepFactor);
        }
        Object object = this.metadataLock;
        synchronized (object) {
            policy = this.policyConfig;
            max = this.maxPartitionsPerTenant;
            cur = this.numPartitions(tenant);
        }
        policy.validateTopicConfigs(reqMetadata.configs());
        CreateTopicPolicy.ensureValidPartitionCount(tenant, max, cur, numPartitionsPassed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.metricsLock;
        synchronized (object) {
            Utils.closeQuietly(this.partitionsByTenantMetrics, (String)"partitionsByTenantMetrics");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numPartitions(String tenant) {
        Object object = this.metadataLock;
        synchronized (object) {
            if (this.tenantToNumPartitions == null) {
                log.info("Policy has not been initialized with topic metadata, returning NOT_CONTROLLER");
                throw new NotControllerException("Initialization of topic metadata has not been completed");
            }
            int numTenantPartitions = this.tenantToNumPartitions.getOrDefault(tenant, 0);
            log.debug("Found {} partition(s) for tenant {}.", (Object)numTenantPartitions, (Object)tenant);
            return numTenantPartitions;
        }
    }

    static void ensureValidPartitionCount(String tenant, int max, int cur, int added) throws PolicyViolationException {
        if (added > max) {
            throw new PolicyViolationException(String.format("You may not create more than the maximum number of partitions (%d).", max));
        }
        long total = cur;
        if ((total += (long)added) > (long)max) {
            throw new PolicyViolationException(String.format("You may not create more than %d new partitions. Adding the requested number of partitions will exceed %d total partitions. Currently, there are %d total topic partitions", max - cur, max, cur));
        }
        log.debug("Validated adding {} partitions to {} current partitions (total={}, max={}) for {}", new Object[]{added, cur, total, max, tenant});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullUpdate(Iterator<Map.Entry<String, Integer>> iterator) {
        Object tenant;
        HashMap<String, Integer> newTenantToNumPartitions = new HashMap<String, Integer>();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> entry = iterator.next();
            String topicName = entry.getKey();
            tenant = TenantHelpers.extractTenantPrefix((String)topicName, (boolean)false);
            if (tenant == null) continue;
            newTenantToNumPartitions.put((String)tenant, newTenantToNumPartitions.getOrDefault(tenant, 0) + entry.getValue());
        }
        HashMap<String, Integer> changedTenantToNumPartitions = new HashMap<String, Integer>();
        Object object = this.metricsLock;
        synchronized (object) {
            tenant = this.metadataLock;
            synchronized (tenant) {
                Map<Object, Object> oldTenantToNumPartitions = this.tenantToNumPartitions == null ? Collections.emptyMap() : this.tenantToNumPartitions;
                this.tenantToNumPartitions = newTenantToNumPartitions;
                for (Map.Entry<String, Integer> entry : this.tenantToNumPartitions.entrySet()) {
                    Integer prevValue;
                    String tenant2 = entry.getKey();
                    Integer newValue = entry.getValue();
                    if (newValue.equals(prevValue = (Integer)oldTenantToNumPartitions.remove(tenant2))) continue;
                    changedTenantToNumPartitions.put(tenant2, newValue);
                }
                for (String string : oldTenantToNumPartitions.keySet()) {
                    changedTenantToNumPartitions.put(string, 0);
                }
            }
            boolean removedSome = false;
            for (Map.Entry entry : changedTenantToNumPartitions.entrySet()) {
                if ((Integer)entry.getValue() == 0) {
                    this.partitionsByTenantMetrics.remove(entry.getKey());
                    removedSome = true;
                    continue;
                }
                this.partitionsByTenantMetrics.update(entry.getKey(), entry.getValue());
            }
            if (removedSome) {
                this.partitionsByTenantMetrics.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialUpdate(String topicName, int numPartitionsChange) {
        String tenant = TenantHelpers.extractTenantPrefix((String)topicName, (boolean)false);
        if (tenant == null || numPartitionsChange == 0) {
            return;
        }
        Object object = this.metricsLock;
        synchronized (object) {
            Object object2 = this.metadataLock;
            synchronized (object2) {
                int numTenantPartitions = this.tenantToNumPartitions.getOrDefault(tenant, 0);
                int newNumTenantPartitions = numTenantPartitions + numPartitionsChange;
                if (newNumTenantPartitions == 0) {
                    this.tenantToNumPartitions.remove(tenant);
                    this.partitionsByTenantMetrics.remove((Object)tenant);
                    this.partitionsByTenantMetrics.flush();
                } else {
                    this.tenantToNumPartitions.put(tenant, newNumTenantPartitions);
                    this.partitionsByTenantMetrics.update((Object)tenant, (Object)newNumTenantPartitions);
                }
            }
        }
    }

    public Set<String> reconfigurableConfigs() {
        return RECONFIGURABLE_CONFIGS;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        new TopicPolicyConfig(configs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(Map<String, ?> configs) {
        TopicPolicyConfig newPolicyConfig = new TopicPolicyConfig(configs);
        Object object = this.metadataLock;
        synchronized (object) {
            this.policyConfig = newPolicyConfig;
            this.requiredRepFactor = newPolicyConfig.getShort("confluent.plugins.topic.policy.replication.factor");
            this.maxPartitionsPerTenant = newPolicyConfig.getInt("confluent.plugins.topic.policy.max.partitions.per.tenant");
        }
    }
}

