/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import io.confluent.kafka.multitenant.MultiTenantConfigRestrictions;
import io.confluent.kafka.server.plugins.policy.AbstractPolicyConfig;
import io.confluent.kafka.server.plugins.policy.PolicyUtils;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkUtils;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.PolicyViolationException;

public class ClusterLinkPolicyConfig
extends AbstractPolicyConfig {
    public static final String BASE_PREFIX = "confluent.plugins.";
    public static final String CLUSTER_LINK_PREFIX = "confluent.plugins.link.policy.";
    public static final String DOC_MIN_PREFIX = "The minimum allowed value for the ";
    public static final String DOC_MAX_PREFIX = "The maximum allowed value for the ";
    public static final String DOC_SUFFIX = " cluster link config property.";
    public static final String ACL_SYNC_MS_MIN_CONFIG = "confluent.plugins.link.policy." + ClusterLinkConfig.AclSyncMsProp() + ".min";
    public static final int DEFAULT_ACL_SYNC_MS_MIN = 1000;
    protected static final String ACL_SYNC_MS_MIN_CONFIG_DOC = "The minimum allowed value for the " + ClusterLinkConfig.AclSyncMsProp() + " cluster link config property.";
    public static final String ACL_SYNC_MS_MAX_CONFIG = "confluent.plugins.link.policy." + ClusterLinkConfig.AclSyncMsProp() + ".max";
    public static final int DEFAULT_ACL_SYNC_MS_MAX = 300000;
    protected static final String ACL_SYNC_MS_MAX_CONFIG_DOC = "The maximum allowed value for the " + ClusterLinkConfig.AclSyncMsProp() + " cluster link config property.";
    public static final String CONSUMER_OFFSET_SYNC_MS_MIN_CONFIG = "confluent.plugins.link.policy." + ClusterLinkConfig.ConsumerOffsetSyncMsProp() + ".min";
    public static final int DEFAULT_CONSUMER_OFFSET_SYNC_MS_MIN = 1000;
    protected static final String CONSUMER_OFFSET_SYNC_MS_MIN_CONFIG_DOC = "The minimum allowed value for the " + ClusterLinkConfig.ConsumerOffsetSyncMsProp() + " cluster link config property.";
    public static final String CONSUMER_OFFSET_SYNC_MS_MAX_CONFIG = "confluent.plugins.link.policy." + ClusterLinkConfig.ConsumerOffsetSyncMsProp() + ".max";
    public static final int DEFAULT_CONSUMER_OFFSET_SYNC_MS_MAX = 300000;
    protected static final String CONSUMER_OFFSET_SYNC_MS_MAX_CONFIG_DOC = "The maximum allowed value for the " + ClusterLinkConfig.ConsumerOffsetSyncMsProp() + " cluster link config property.";
    public static final String TOPIC_CONFIG_SYNC_MS_MIN_CONFIG = "confluent.plugins.link.policy." + ClusterLinkConfig.TopicConfigSyncMsProp() + ".min";
    public static final int DEFAULT_TOPIC_CONFIG_SYNC_MS_MIN = 1000;
    protected static final String TOPIC_CONFIG_SYNC_MS_MIN_CONFIG_DOC = "The minimum allowed value for the " + ClusterLinkConfig.TopicConfigSyncMsProp() + " cluster link config property.";
    public static final String TOPIC_CONFIG_SYNC_MS_MAX_CONFIG = "confluent.plugins.link.policy." + ClusterLinkConfig.TopicConfigSyncMsProp() + ".max";
    public static final int DEFAULT_TOPIC_CONFIG_SYNC_MS_MAX = 300000;
    protected static final String TOPIC_CONFIG_SYNC_MS_MAX_CONFIG_DOC = "The maximum allowed value for the " + ClusterLinkConfig.TopicConfigSyncMsProp() + " cluster link config property.";
    public static final String SASL_MECHANISMS_ALLOWED_CONFIG = "confluent.plugins.link.policy.sasl.mechanism.allowed";
    public static final List<String> DEFAULT_SASL_MECHANISMS_ALLOWED = Arrays.asList("PLAIN", "SCRAM-SHA-256", "SCRAM-SHA-512");
    protected static final String SASL_MECHANISMS_ALLOWED_CONFIG_DOC = "The allowed values for the sasl.mechanism cluster link config property.";
    public static final String REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_MIN_CONFIG = "confluent.plugins.link.policy." + KafkaConfig.ReplicaSocketReceiveBufferBytesProp() + ".min";
    public static final int DEFAULT_REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_MIN = 32768;
    protected static final String REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_MIN_DOC = "The minimum allowed value for the " + KafkaConfig.ReplicaSocketReceiveBufferBytesProp() + " cluster link config property.";
    public static final String REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_MAX_CONFIG = "confluent.plugins.link.policy." + KafkaConfig.ReplicaSocketReceiveBufferBytesProp() + ".max";
    public static final int DEFAULT_REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_MAX = 0x100000;
    protected static final String REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_MAX_DOC = "The maximum allowed value for the " + KafkaConfig.ReplicaSocketReceiveBufferBytesProp() + " cluster link config property.";
    public static final String AVAILABILITY_CHECK_MS_MIN_CONFIG = "confluent.plugins.link.policy." + ClusterLinkConfig.AvailabilityCheckMsProp() + ".min";
    public static final int DEFAULT_AVAILABILITY_CHECK_MS_MIN = 3000;
    public static final String AVAILABILITY_CHECK_MS_MIN_DOC = "The minimum allowed value for the " + ClusterLinkConfig.AvailabilityCheckMsProp() + " cluster link config property.";
    public static final String AVAILABILITY_CHECK_MS_MAX_CONFIG = "confluent.plugins.link.policy." + ClusterLinkConfig.AvailabilityCheckMsProp() + ".max";
    public static final int DEFAULT_AVAILABILITY_CHECK_MS_MAX = 60000;
    public static final String AVAILABILITY_CHECK_MS_MAX_DOC = "The maximum allowed value for the " + ClusterLinkConfig.AvailabilityCheckMsProp() + " cluster link config property.";
    public static final String MAX_DEST_LINKS_PER_TENANT_CONFIG = "confluent.plugins.cluster.link.policy.max.destination.links.per.tenant";
    public static final String MAX_SOURCE_LINKS_PER_TENANT_CONFIG = "confluent.plugins.cluster.link.policy.max.source.links.per.tenant";
    private static final ConfigDef CONFIG = new ConfigDef().define(ACL_SYNC_MS_MIN_CONFIG, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, ACL_SYNC_MS_MIN_CONFIG_DOC).define(ACL_SYNC_MS_MAX_CONFIG, ConfigDef.Type.INT, (Object)300000, ConfigDef.Importance.LOW, ACL_SYNC_MS_MAX_CONFIG_DOC).define(CONSUMER_OFFSET_SYNC_MS_MIN_CONFIG, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, CONSUMER_OFFSET_SYNC_MS_MIN_CONFIG_DOC).define(CONSUMER_OFFSET_SYNC_MS_MAX_CONFIG, ConfigDef.Type.INT, (Object)300000, ConfigDef.Importance.LOW, CONSUMER_OFFSET_SYNC_MS_MAX_CONFIG_DOC).define(TOPIC_CONFIG_SYNC_MS_MIN_CONFIG, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, TOPIC_CONFIG_SYNC_MS_MIN_CONFIG_DOC).define(TOPIC_CONFIG_SYNC_MS_MAX_CONFIG, ConfigDef.Type.INT, (Object)300000, ConfigDef.Importance.LOW, TOPIC_CONFIG_SYNC_MS_MAX_CONFIG_DOC).define("confluent.plugins.link.policy.sasl.mechanism.allowed", ConfigDef.Type.LIST, DEFAULT_SASL_MECHANISMS_ALLOWED, ConfigDef.Importance.MEDIUM, "The allowed values for the sasl.mechanism cluster link config property.").define(REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_MIN_CONFIG, ConfigDef.Type.INT, (Object)32768, ConfigDef.Importance.LOW, REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_MIN_DOC).define(REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_MAX_CONFIG, ConfigDef.Type.INT, (Object)0x100000, ConfigDef.Importance.LOW, REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_MAX_DOC).define(AVAILABILITY_CHECK_MS_MIN_CONFIG, ConfigDef.Type.INT, (Object)3000, ConfigDef.Importance.LOW, AVAILABILITY_CHECK_MS_MIN_DOC).define(AVAILABILITY_CHECK_MS_MAX_CONFIG, ConfigDef.Type.INT, (Object)60000, ConfigDef.Importance.LOW, AVAILABILITY_CHECK_MS_MAX_DOC).define("confluent.plugins.cluster.link.policy.max.destination.links.per.tenant", ConfigDef.Type.INT, (Object)5, ConfigDef.Importance.LOW, "The maximum destination cluster links per tenant.").define("confluent.plugins.cluster.link.policy.max.source.links.per.tenant", ConfigDef.Type.INT, (Object)5, ConfigDef.Importance.LOW, "The maximum source cluster links per tenant. This limit is only applicable to source initiated links.");
    private final Set<String> allowedSaslMechanisms = new HashSet<String>();

    public ClusterLinkPolicyConfig(Map<String, ?> clientConfigs) {
        super(CONFIG, clientConfigs);
        this.allowedSaslMechanisms.addAll(this.getList(SASL_MECHANISMS_ALLOWED_CONFIG));
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toRst());
    }

    private void validateConfigsAreInRange(Map<String, String> configs) {
        this.checkPolicyMin(configs, ACL_SYNC_MS_MIN_CONFIG, ClusterLinkConfig.AclSyncMsProp());
        this.checkPolicyMax(configs, ACL_SYNC_MS_MAX_CONFIG, ClusterLinkConfig.AclSyncMsProp());
        this.checkPolicyMin(configs, CONSUMER_OFFSET_SYNC_MS_MIN_CONFIG, ClusterLinkConfig.ConsumerOffsetSyncMsProp());
        this.checkPolicyMax(configs, CONSUMER_OFFSET_SYNC_MS_MAX_CONFIG, ClusterLinkConfig.ConsumerOffsetSyncMsProp());
        this.checkPolicyMin(configs, TOPIC_CONFIG_SYNC_MS_MIN_CONFIG, ClusterLinkConfig.TopicConfigSyncMsProp());
        this.checkPolicyMax(configs, TOPIC_CONFIG_SYNC_MS_MAX_CONFIG, ClusterLinkConfig.TopicConfigSyncMsProp());
        this.checkPolicyMin(configs, REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_MIN_CONFIG, KafkaConfig.ReplicaSocketReceiveBufferBytesProp());
        this.checkPolicyMax(configs, REPLICA_SOCKET_RECEIVE_BUFFER_BYTES_MAX_CONFIG, KafkaConfig.ReplicaSocketReceiveBufferBytesProp());
        this.checkPolicyMin(configs, AVAILABILITY_CHECK_MS_MIN_CONFIG, ClusterLinkConfig.AvailabilityCheckMsProp());
        this.checkPolicyMax(configs, AVAILABILITY_CHECK_MS_MAX_CONFIG, ClusterLinkConfig.AvailabilityCheckMsProp());
    }

    public void validateClusterLinkConfigs(Map<String, String> configs) {
        if (configs == null) {
            return;
        }
        PolicyUtils.validateConfigsAreUpdatable(configs, configName -> MultiTenantConfigRestrictions.UPDATABLE_CLUSTER_LINK_CONFIGS.contains(configName));
        this.validateConfigsAreInRange(configs);
        String saslMechanism = configs.get("sasl.mechanism");
        if (saslMechanism != null && !this.allowedSaslMechanisms.contains(saslMechanism.toUpperCase(Locale.ROOT))) {
            throw new PolicyViolationException("sasl.mechanism=" + saslMechanism + " must be one of: " + this.allowedSaslMechanisms);
        }
        ClusterLinkPolicyConfig.validateBootstrap(configs);
    }

    static void validateBootstrap(Map<String, String> configs) {
        String bootstrapConfig = configs.get("bootstrap.servers");
        String dnsLookupConfig = configs.get("client.dns.lookup");
        String linkMode = configs.get(ClusterLinkConfig.LinkModeProp());
        if (bootstrapConfig == null || "SOURCE".equalsIgnoreCase(linkMode)) {
            return;
        }
        ClientDnsLookup dnsLookup = dnsLookupConfig == null ? ClientDnsLookup.USE_ALL_DNS_IPS : ClientDnsLookup.forConfig((String)dnsLookupConfig);
        List bootstrapServers = (List)ConfigDef.parseType((String)"bootstrap.servers", (Object)bootstrapConfig, (ConfigDef.Type)ConfigDef.Type.LIST);
        ArrayList<InetSocketAddress> invalidAddresses = new ArrayList<InetSocketAddress>();
        for (InetSocketAddress inetSocketAddress : ClientUtils.parseAndValidateAddresses((List)bootstrapServers, (ClientDnsLookup)dnsLookup)) {
            if (!ClusterLinkUtils.isInternalNetworkOrPort((InetSocketAddress)inetSocketAddress)) continue;
            invalidAddresses.add(inetSocketAddress);
        }
        if (!invalidAddresses.isEmpty()) {
            throw new PolicyViolationException("Invalid bootstrap addresses or ports that cannot be used for cluster links on Confluent Cloud: " + invalidAddresses);
        }
    }
}

