/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantSaslServer;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.server.plugins.auth.SaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.SaslServerSupplier;
import io.confluent.kafka.server.plugins.auth.stats.AuthenticationStats;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.SecretsLogFailedException;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.security.plain.internals.PlainServerCallbackHandler;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PlainSaslServer
implements MultiTenantSaslServer {
    public static final String PLAIN_MECHANISM = "PLAIN";
    private final SaslAuthenticator authenticator;
    private static final AuthenticationStats STATS = AuthenticationStats.getInstance();
    private static final Logger log = LoggerFactory.getLogger(PlainSaslServer.class);
    private boolean complete;
    private String authorizationId;
    private String authenticationId;
    private TenantMetadata tenantMetadata;
    private String username = "";
    private final PathAwareSniHostName sniHostName;

    public PlainSaslServer(List<AppConfigurationEntry> jaasContextEntries, SaslAuthenticator authenticator) {
        this(jaasContextEntries, authenticator, null);
    }

    public PlainSaslServer(List<AppConfigurationEntry> jaasContextEntries, SaslAuthenticator authenticator, PathAwareSniHostName sniHostName) {
        this.authenticator = authenticator;
        authenticator.initialize(jaasContextEntries);
        this.sniHostName = sniHostName;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        try {
            byte[] result = this.doEvaluateResponse(response);
            STATS.incrSucceeded();
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e) {
            STATS.incrFailed();
            String cause = e.getCause() == null ? "" : e.getCause().getMessage();
            log.debug("SASL/PLAIN authentication failed: {}", (Object)cause, (Object)e);
            throw e;
        }
        finally {
            this.clearMdc();
        }
    }

    private void clearMdc() {
        MDC.remove((String)"username");
        MDC.remove((String)"saslMechanism");
        MDC.remove((String)"authorizationId");
        MDC.remove((String)"tenant");
    }

    private byte[] doEvaluateResponse(byte[] responseBytes) throws SaslException {
        MDC.put((String)"saslMechanism", (String)PLAIN_MECHANISM);
        String response = new String(responseBytes, StandardCharsets.UTF_8);
        List<String> tokens = this.extractTokens(response);
        String authorizationIdFromClient = tokens.get(0);
        String username = tokens.get(1);
        String password = tokens.get(2);
        if (username.isEmpty()) {
            throw new SaslAuthenticationException("Authentication failed: username not specified", AuthenticationErrorInfo.UNKNOWN_USER_ERROR);
        }
        MDC.put((String)"username", (String)username);
        this.username = username;
        if (password.isEmpty()) {
            AuthenticationErrorInfo errorInfo = this.getErrorInfo();
            throw new SaslAuthenticationException("Authentication failed: password not specified", errorInfo);
        }
        if (!authorizationIdFromClient.isEmpty() && !authorizationIdFromClient.equals(username)) {
            AuthenticationErrorInfo errorInfo = this.getErrorInfo();
            throw new SaslAuthenticationException("Authentication failed: Client requested an authorization id that is different from username", errorInfo);
        }
        MultiTenantPrincipal principal = this.authenticator.authenticate(username, password, Optional.ofNullable(this.sniHostName));
        this.authorizationId = principal.user();
        this.authenticationId = username;
        this.tenantMetadata = principal.tenantMetadata();
        String userResourceId = this.tenantMetadata.userResourceId;
        MDC.put((String)"authorizationId", (String)this.authorizationId);
        MDC.put((String)"tenant", (String)this.tenantMetadata.tenantName);
        log.debug("SASL/PLAIN authentication succeeded for userId : {},  userResourceId : {}, apiKey : {}, clusterId : {}", new Object[]{this.authorizationId, userResourceId, username, this.tenantMetadata.tenantName});
        this.complete = true;
        return new byte[0];
    }

    private AuthenticationErrorInfo getErrorInfo() throws SaslException {
        String clusterId = this.authenticator.clusterId(this.username).orElse("");
        return new AuthenticationErrorInfo(AuditEventStatus.UNAUTHENTICATED, "", this.username, clusterId);
    }

    private List<String> extractTokens(String string) {
        ArrayList<String> tokens = new ArrayList<String>();
        int startIndex = 0;
        for (int i = 0; i < 4; ++i) {
            int endIndex = string.indexOf("\u0000", startIndex);
            if (endIndex == -1) {
                tokens.add(string.substring(startIndex));
                break;
            }
            tokens.add(string.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
        }
        if (tokens.size() != 3) {
            throw new SaslAuthenticationException("Invalid SASL/PLAIN response: expected 3 tokens, got " + tokens.size(), AuthenticationErrorInfo.UNKNOWN_USER_ERROR);
        }
        return tokens;
    }

    @Override
    public TenantMetadata tenantMetadata() {
        this.throwIfNotComplete();
        return this.tenantMetadata;
    }

    @Override
    public String getAuthorizationID() {
        this.throwIfNotComplete();
        return this.authorizationId;
    }

    @Override
    public String authenticationId() {
        return this.authenticationId;
    }

    @Override
    public String getMechanismName() {
        return PLAIN_MECHANISM;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        this.throwIfNotComplete();
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) {
        this.throwIfNotComplete();
        return Arrays.copyOfRange(incoming, offset, offset + len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) {
        this.throwIfNotComplete();
        return Arrays.copyOfRange(outgoing, offset, offset + len);
    }

    @Override
    public void dispose() {
    }

    private void throwIfNotComplete() {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
    }

    @Override
    public String userIdentifier() {
        return this.username;
    }

    public static class PlainSaslServerFactory
    implements SaslServerFactory {
        private final SaslServerSupplier saslServerSupplier;

        public PlainSaslServerFactory(SaslServerSupplier saslServerSupplier) {
            this.saslServerSupplier = saslServerSupplier;
        }

        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            if (!PlainSaslServer.PLAIN_MECHANISM.equals(mechanism)) {
                throw new SaslException(String.format("Mechanism '%s' is not supported. Only PLAIN is supported.", mechanism));
            }
            if (!(cbh instanceof PlainServerCallbackHandler)) {
                throw new SaslException("CallbackHandler must be of type PlainServerCallbackHandler, but it is: " + cbh.getClass());
            }
            try {
                Field field = PlainServerCallbackHandler.class.getDeclaredField("jaasConfigEntries");
                field.setAccessible(true);
                List jaasContextEntries = (List)field.get(cbh);
                return this.saslServerSupplier.get(jaasContextEntries, props);
            }
            catch (SecretsLogFailedException e) {
                throw new SecretsLogFailedException("Could not find source topic", (Throwable)e);
            }
            catch (Throwable e) {
                throw new SaslException("Could not obtain JAAS context", e);
            }
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            String noPlainText = (String)props.get("javax.security.sasl.policy.noplaintext");
            if ("true".equals(noPlainText)) {
                return new String[0];
            }
            return new String[]{PlainSaslServer.PLAIN_MECHANISM};
        }
    }
}

