/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.server.plugins.auth.AuthAttemptCache;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecrets;
import io.confluent.kafka.server.plugins.auth.SaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.sasl.SaslException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlainSaslAuthenticator
implements SaslAuthenticator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String AUTHENTICATION_FAILED_MSG = "Authentication failed";
    private static final String NOT_PROVIDED_MSG = "<not-provided>";
    private static final String SASL_MECHANISM_PLAIN = "PLAIN";
    protected SniValidationMode mode;
    protected static final AuthAttemptCache SUCCESSFUL_AUTH_CACHE = new AuthAttemptCache();
    protected static final AuthAttemptCache FAILED_AUTH_CACHE = new AuthAttemptCache();
    private final AuthAttemptCache successfulAuthCache;
    private final AuthAttemptCache failedAuthCache;

    protected abstract MultiTenantSaslSecrets loadSecrets();

    public PlainSaslAuthenticator(AuthAttemptCache successfulAuthCache, AuthAttemptCache failedAuthCache) {
        this.successfulAuthCache = successfulAuthCache;
        this.failedAuthCache = failedAuthCache;
    }

    public static MultiTenantPrincipal multiTenantPrincipal(String username, MultiTenantSaslConfigEntry userInfo) {
        TenantMetadata tenantMetadata = new TenantMetadata.Builder(userInfo.logicalClusterId, userInfo.userResourceId).serviceAccount(userInfo.serviceAccount()).apiKeyAuthenticated(true).healthcheckTenant(false).build();
        return new MultiTenantPrincipal(userInfo.userId, username, tenantMetadata);
    }

    @Override
    public MultiTenantPrincipal authenticate(String username, String password, Optional<PathAwareSniHostName> sniHostName) throws SaslException, SaslAuthenticationException {
        try {
            Optional<String> suppliedClusterId = sniHostName.map(PathAwareSniHostName::logicalClusterId);
            MultiTenantSaslSecrets secrets = this.loadSecretsIfExists(suppliedClusterId);
            MultiTenantSaslConfigEntry userInfo = this.getUserInfoIfExists(secrets.entries(), username, suppliedClusterId);
            this.verifySaslMechanismMatch(userInfo, username);
            this.verifyPassword(userInfo, username, password);
            this.verifyBrokerHostName(userInfo, username, sniHostName, suppliedClusterId, this.mode);
            return PlainSaslAuthenticator.multiTenantPrincipal(username, userInfo);
        }
        catch (SaslAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Unexpected exception during authentication for user {}", (Object)username, (Object)e);
            throw new SaslException("Authentication failed: Unexpected exception", e);
        }
    }

    private MultiTenantSaslSecrets loadSecretsIfExists(Optional<String> suppliedClusterId) {
        MultiTenantSaslSecrets secrets = this.loadSecrets();
        if (secrets == null) {
            String errorMessage = "Unable to find api key";
            AuthenticationErrorInfo errorInfo = this.errorInfo(AuditEventStatus.UNAUTHENTICATED, "", suppliedClusterId.orElse(""), errorMessage);
            throw new SaslAuthenticationException(AUTHENTICATION_FAILED_MSG, errorInfo);
        }
        return secrets;
    }

    private MultiTenantSaslConfigEntry getUserInfoIfExists(Map<String, MultiTenantSaslConfigEntry> credentials, String username, Optional<String> suppliedClusterId) {
        MultiTenantSaslConfigEntry userInfo = credentials.get(username);
        if (userInfo == null) {
            String errorMessage = "Unknown user " + username;
            AuthenticationErrorInfo errorInfo = this.errorInfo(AuditEventStatus.UNKNOWN_USER_DENIED, username, suppliedClusterId.orElse(""), errorMessage);
            throw new SaslAuthenticationException(AUTHENTICATION_FAILED_MSG, errorInfo);
        }
        return userInfo;
    }

    private void verifySaslMechanismMatch(MultiTenantSaslConfigEntry userInfo, String username) {
        if (!SASL_MECHANISM_PLAIN.equals(userInfo.saslMechanism)) {
            String errorMessage = "Wrong SASL mechanism " + userInfo.saslMechanism + " for user " + username;
            AuthenticationErrorInfo errorInfo = this.errorInfo(AuditEventStatus.UNAUTHENTICATED, username, userInfo.logicalClusterId, errorMessage);
            throw new SaslAuthenticationException(AUTHENTICATION_FAILED_MSG, errorInfo);
        }
    }

    private void verifyPassword(MultiTenantSaslConfigEntry userInfo, String username, String password) {
        switch (userInfo.hashFunction) {
            case "none": {
                if (userInfo.hashedSecret.equals(password)) break;
                String errorMessage = "Bad password for user " + username;
                AuthenticationErrorInfo errorInfo = this.errorInfo(AuditEventStatus.UNAUTHENTICATED, username, userInfo.logicalClusterId, errorMessage);
                throw new SaslAuthenticationException(AUTHENTICATION_FAILED_MSG, errorInfo);
            }
            case "bcrypt": {
                this.authenticateBcrypt(userInfo, username, password);
                break;
            }
            default: {
                String errorMessage = "Unknown hash function: " + userInfo.hashFunction + " for user " + userInfo.userId;
                AuthenticationErrorInfo errorInfo = this.errorInfo(AuditEventStatus.UNAUTHENTICATED, username, userInfo.logicalClusterId, errorMessage);
                throw new SaslAuthenticationException(AUTHENTICATION_FAILED_MSG, errorInfo);
            }
        }
    }

    private void verifyBrokerHostName(MultiTenantSaslConfigEntry userInfo, String username, Optional<PathAwareSniHostName> sniHostName, Optional<String> suppliedClusterId, SniValidationMode mode) {
        if (mode.sniHostNameMatches(userInfo.logicalClusterId, suppliedClusterId, sniHostName)) {
            return;
        }
        this.failSNIHostNameAuthentication(userInfo, username, suppliedClusterId);
    }

    private void failSNIHostNameAuthentication(MultiTenantSaslConfigEntry userInfo, String username, Optional<String> suppliedClusterId) {
        String errorMessage = String.format("SNI cluster ID: %s does not match API key cluster ID %s for user name: %s", suppliedClusterId.orElse(NOT_PROVIDED_MSG), userInfo.logicalClusterId, username);
        AuthenticationErrorInfo errorInfo = this.errorInfo(AuditEventStatus.UNAUTHENTICATED, username, userInfo.logicalClusterId, errorMessage);
        throw new SaslAuthenticationException(AUTHENTICATION_FAILED_MSG, errorInfo);
    }

    private void authenticateBcrypt(MultiTenantSaslConfigEntry userInfo, String username, String password) {
        if (this.isCached(userInfo, username, password, this.successfulAuthCache)) {
            return;
        }
        if (this.isCached(userInfo, username, password, this.failedAuthCache)) {
            this.throwAuthException(username, userInfo);
        }
        if (BCrypt.checkpw((String)password, (String)userInfo.hashedSecret)) {
            this.successfulAuthCache.put(username, password, userInfo.hashedSecret);
        } else {
            this.failedAuthCache.put(username, password, userInfo.hashedSecret);
            this.throwAuthException(username, userInfo);
        }
    }

    private boolean isCached(MultiTenantSaslConfigEntry userInfo, String username, String password, AuthAttemptCache authCache) {
        String hash = authCache.get(username, password);
        if (hash != null) {
            if (hash.equals(userInfo.hashedSecret)) {
                return true;
            }
            this.successfulAuthCache.invalidate(username, password);
            this.failedAuthCache.invalidate(username, password);
        }
        return false;
    }

    private void throwAuthException(String username, MultiTenantSaslConfigEntry userInfo) {
        String errorMessage = "Bad password for user " + username;
        AuthenticationErrorInfo errorInfo = this.errorInfo(AuditEventStatus.UNAUTHENTICATED, username, userInfo.logicalClusterId, errorMessage);
        throw new SaslAuthenticationException(AUTHENTICATION_FAILED_MSG, errorInfo);
    }

    private AuthenticationErrorInfo errorInfo(AuditEventStatus auditEventStatus, String username, String clusterId, String errorMessage) {
        return new AuthenticationErrorInfo(auditEventStatus, errorMessage, username, clusterId);
    }

    static String configEntryOption(List<AppConfigurationEntry> configurationEntries, String key, String loginModuleName) {
        for (AppConfigurationEntry entry : configurationEntries) {
            Object val;
            if (loginModuleName != null && !loginModuleName.equals(entry.getLoginModuleName()) || (val = entry.getOptions().get(key)) == null) continue;
            return (String)val;
        }
        return null;
    }

    @Override
    public Optional<String> clusterId(String username) throws SaslException {
        try {
            MultiTenantSaslSecrets secrets = this.loadSecrets();
            return Optional.ofNullable(secrets.entries().get(username)).map(MultiTenantSaslConfigEntry::logicalClusterId);
        }
        catch (Exception e) {
            this.log.error("Unexpected exception during authentication for user {}", (Object)username, (Object)e);
            throw new SaslException("Authentication failed: Unexpected exception", e);
        }
    }
}

