/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authorizer.acl;

import io.confluent.kafka.security.authorizer.acl.AclMapper;
import io.confluent.kafka.security.authorizer.acl.ExtendedAccessRuleProvider;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerData;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;

public class StandardAclProvider
implements ExtendedAccessRuleProvider {
    private StandardAuthorizer authorizer;

    public StandardAclProvider() {
    }

    StandardAclProvider(StandardAuthorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void configure(Map<String, ?> configs) {
        this.authorizer = new StandardAuthorizer();
        this.authorizer.configure(configs);
    }

    public String providerName() {
        return ConfluentBuiltInProviders.AccessRuleProviders.KRAFT_ACL.name();
    }

    public boolean mayDeny() {
        return true;
    }

    public boolean usesMetadataFromThisKafkaCluster() {
        return true;
    }

    public boolean isSuperUser(KafkaPrincipal principal, Scope scope) {
        return false;
    }

    @Override
    public AuthorizeRule findRule(Set<KafkaPrincipal> matchingPrincipals, String host, io.confluent.security.authorizer.Action action) {
        Action standardAction = new Action(AclMapper.aclOperation(action.operation()), ResourcePattern.to((ResourcePattern)action.resourcePattern()), action.resourceReferenceCount(), action.logIfAllowed(), action.logIfDenied());
        StandardAuthorizerData.MatchingRule match = this.authorizer.findRule(matchingPrincipals, host, standardAction);
        AuthorizeRule result = new AuthorizeRule();
        if (match instanceof StandardAuthorizerData.MatchingAclRule) {
            StandardAuthorizerData.MatchingAclRule matchingAclRule = (StandardAuthorizerData.MatchingAclRule)match;
            result.addRuleIfNotExist(AclMapper.accessRule(matchingAclRule.acl()));
        } else if (match instanceof StandardAuthorizerData.DefaultRule) {
            result.noResourceAcls(match.result() == AuthorizationResult.ALLOWED);
        }
        return result;
    }

    @Override
    public void addMatchingRules(ResourceAuthorizeRules matchingRules, Set<KafkaPrincipal> matchingPrincipals, String host, Operation operation, Scope resourceScope, ResourceType resourceType) {
        List matchingAcls = this.authorizer.findRulesByResourceType(SecurityUtils.resourceType((String)resourceType.name()), SecurityUtils.operation((String)operation.name()), matchingPrincipals, host);
        for (StandardAcl matchingAcl : matchingAcls) {
            matchingRules.addRuleIfNotExist(AclMapper.accessRule(matchingAcl));
        }
    }

    public void close() throws IOException {
        this.authorizer.close();
    }

    public Optional<Authorizer> asAuthorizer() {
        return Optional.of(this.authorizer);
    }
}

