/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authorizer.acl;

import io.confluent.kafka.security.authorizer.acl.AclMapper;
import io.confluent.kafka.security.authorizer.acl.ExtendedAccessRuleProvider;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.PermissionType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import scala.Option;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.TreeMap;

public class AclProvider
extends AclAuthorizer
implements ExtendedAccessRuleProvider {
    private Sensor aclsProcessedSensor;

    public String providerName() {
        return ConfluentBuiltInProviders.AccessRuleProviders.ZK_ACL.name();
    }

    public boolean isSuperUser(KafkaPrincipal principal, Scope scope) {
        return false;
    }

    public boolean mayDeny() {
        return true;
    }

    public boolean usesMetadataFromThisKafkaCluster() {
        return false;
    }

    @Override
    public AuthorizeRule findRule(Set<KafkaPrincipal> matchingPrincipals, String host, io.confluent.security.authorizer.Action action) {
        Option<AclEntry> allowAcl;
        AclAuthorizer.AclCacheTuple caches = this.aclCachePairSnapshot();
        io.confluent.security.authorizer.ResourcePattern resource = action.resourcePattern();
        ResourceType resourceType = SecurityUtils.resourceType((String)resource.resourceType().name());
        AuthorizeRule authorizeRule = new AuthorizeRule();
        authorizeRule.noResourceAcls(!this.hasAclForResource(caches.aclCache(), resourceType, resource.name()));
        Option<AclEntry> denyAcl = this.findMatchingAclEntry((HashMap<KafkaPrincipal, TreeMap<ResourcePattern, AclAuthorizer.VersionedAcls>>)caches.aclCacheByPrincipal(), matchingPrincipals, host, action.operation(), resourceType, resource.name(), PermissionType.DENY);
        if (!denyAcl.isEmpty()) {
            authorizeRule.addRuleIfNotExist(AclMapper.accessRule((AclEntry)denyAcl.get()));
            return authorizeRule;
        }
        if (!authorizeRule.allowRule().isPresent() && !(allowAcl = this.findMatchingAclEntry((HashMap<KafkaPrincipal, TreeMap<ResourcePattern, AclAuthorizer.VersionedAcls>>)caches.aclCacheByPrincipal(), matchingPrincipals, host, action.operation(), resourceType, resource.name(), PermissionType.ALLOW)).isEmpty()) {
            authorizeRule.addRuleIfNotExist(AclMapper.accessRule((AclEntry)allowAcl.get()));
        }
        return authorizeRule;
    }

    @Override
    public void addMatchingRules(ResourceAuthorizeRules matchingRules, Set<KafkaPrincipal> matchingPrincipals, String host, Operation operation, Scope resourceScope, io.confluent.security.authorizer.ResourceType resourceType) {
        AclOperation aclOperation = SecurityUtils.operation((String)operation.name());
        ResourceType aclResourceType = SecurityUtils.resourceType((String)resourceType.name());
        List matchingAcls = this.matchingAcls(matchingPrincipals, host, aclOperation, aclResourceType);
        matchingAcls.forEach(acl -> matchingRules.addRuleIfNotExist(AclMapper.accessRule(acl)));
    }

    public CompletionStage<Void> start(ConfluentAuthorizerServerInfo serverInfo, Map<String, ?> interBrokerListenerConfigs) {
        Metrics metrics = serverInfo.metrics();
        this.aclsProcessedSensor = metrics.sensor("zk-acls-processed-count");
        this.aclsProcessedSensor.add((CompoundStat)new Meter(metrics.metricName("zk-acls-processed-rate", "confluent-authorizer-metrics", "The average number of ZooKeeper notifications processed per second by the ZK_ACL provider."), metrics.metricName("zk-acls-processed-total", "confluent-authorizer-metrics", "The total number of ZooKeeper notifications processed per second by the ZK_ACL provider.")));
        return CompletableFuture.completedFuture(null);
    }

    public Map<Endpoint, CompletableFuture<Void>> start(AuthorizerServerInfo serverInfo) {
        return Collections.emptyMap();
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        throw new IllegalStateException("This provider should be used for authorization only using the AccessRuleProvider interface");
    }

    private Option<AclEntry> findMatchingAclEntry(HashMap<KafkaPrincipal, TreeMap<ResourcePattern, AclAuthorizer.VersionedAcls>> cacheByPrincipal, Set<KafkaPrincipal> matchingPrincipals, String host, Operation requestedOperation, ResourceType resourceType, String resourceName, PermissionType permissionType) {
        return this.findMatchingAclFromCacheByPrincipals(cacheByPrincipal, matchingPrincipals, resourceType, resourceName, aclEntry -> {
            Operation aclOperation = AclMapper.operation(aclEntry.operation());
            PermissionType aclPermissionType = AclMapper.permissionType(aclEntry.permissionType());
            KafkaPrincipal aclPrincipal = aclEntry.kafkaPrincipal();
            String aclHost = aclEntry.host();
            return AccessRule.matches((KafkaPrincipal)aclPrincipal, (String)aclHost, (Operation)aclOperation, (PermissionType)aclPermissionType, (Set)matchingPrincipals, (String)host, (Operation)requestedOperation, (PermissionType)permissionType);
        });
    }

    public void updateCache(ResourcePattern resource, AclAuthorizer.VersionedAcls versionedAcls) {
        super.updateCache(resource, versionedAcls);
        if (this.aclsProcessedSensor != null) {
            this.aclsProcessedSensor.record();
        }
    }

    public Optional<Authorizer> asAuthorizer() {
        return Optional.of(this);
    }
}

