/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.metrics.ConnectionSensors;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.server.metrics.AbstractSensorBuilder;
import org.apache.kafka.server.metrics.AbstractSensorCreator;
import org.apache.kafka.server.metrics.MetricsBuilderContext;

public abstract class AbstractConnectionSensorBuilder
extends AbstractSensorBuilder<TenantMetrics.TenantMetricsContext, ConnectionSensors> {
    public AbstractConnectionSensorBuilder(Metrics metrics, TenantMetrics.TenantMetricsContext context) {
        super(metrics, (MetricsBuilderContext)context);
    }

    protected <T> Sensor createSensor(Map<T, ? extends AbstractSensorCreator> sensorCreators, T sensorKey, String sensorName) {
        AbstractConnectionSensorCreator sensorCreator = (AbstractConnectionSensorCreator)sensorCreators.get(sensorKey);
        return sensorCreator.createSensor(this.metrics, sensorName, (TenantMetrics.TenantMetricsContext)this.context);
    }

    protected String sensorSuffix(String unused, TenantMetrics.TenantMetricsContext context) {
        return context.sensorSuffix();
    }

    protected static class ConnectionCountSensorCreator
    extends AbstractConnectionSensorCreator {
        ConnectionCountSensorCreator(String name, String descriptiveName) {
            super(name, descriptiveName);
        }

        @Override
        Sensor createSensor(Metrics metrics, String sensorName, TenantMetrics.TenantMetricsContext context) {
            Sensor sensor = super.createSensor(metrics, sensorName);
            Map<String, String> metricTags = context.metricTags();
            MetricName countMetricName = metrics.metricName(this.name + "-count", context.metricsGroup(), String.format("The current number of %s", this.descriptiveName), metricTags);
            sensor.add(countMetricName, (MeasurableStat)new CumulativeSum());
            return sensor;
        }
    }

    protected static class ConnectionMeterSensorCreator
    extends AbstractConnectionSensorCreator {
        ConnectionMeterSensorCreator(String name, String descriptiveName) {
            super(name, descriptiveName);
        }

        @Override
        Sensor createSensor(Metrics metrics, String sensorName, TenantMetrics.TenantMetricsContext context) {
            Sensor sensor = super.createSensor(metrics, sensorName);
            Map<String, String> metricTags = context.metricTags();
            sensor.add((CompoundStat)this.createMeter(metrics, context.metricsGroup(), metricTags, this.name, this.descriptiveName));
            return sensor;
        }
    }

    static abstract class AbstractConnectionSensorCreator
    extends AbstractSensorCreator {
        AbstractConnectionSensorCreator(String name, String descriptiveName) {
            super(name, descriptiveName);
        }

        abstract Sensor createSensor(Metrics var1, String var2, TenantMetrics.TenantMetricsContext var3);
    }
}

